/*
 * Decompiled with CFR 0.152.
 */
package bt.protocol;

import bt.protocol.InvalidMessageException;
import bt.protocol.Message;

public final class Cancel
implements Message {
    private int pieceIndex;
    private int offset;
    private int length;

    public Cancel(int pieceIndex, int offset, int length) throws InvalidMessageException {
        if (pieceIndex < 0 || offset < 0 || length <= 0) {
            throw new InvalidMessageException("Illegal arguments: piece index (" + pieceIndex + "), offset (" + offset + "), length (" + length + ")");
        }
        this.pieceIndex = pieceIndex;
        this.offset = offset;
        this.length = length;
    }

    public int getPieceIndex() {
        return this.pieceIndex;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "] piece index {" + this.pieceIndex + "}, offset {" + this.offset + "}, length {" + this.length + "}";
    }

    @Override
    public Integer getMessageId() {
        return 8;
    }
}

