/*
 * Decompiled with CFR 0.152.
 */
package bt.protocol;

import bt.BtException;
import bt.metainfo.TorrentId;
import bt.net.PeerId;
import bt.protocol.InvalidMessageException;
import bt.protocol.Message;
import bt.protocol.Protocols;

public final class Handshake
implements Message {
    private static final int UPPER_RESERVED_BOUND = 63;
    private byte[] reserved;
    private TorrentId torrentId;
    private PeerId peerId;

    public Handshake(byte[] reserved, TorrentId torrentId, PeerId peerId) throws InvalidMessageException {
        this.reserved = reserved;
        this.torrentId = torrentId;
        this.peerId = peerId;
    }

    public boolean isReservedBitSet(int bitIndex) {
        return Protocols.getBit(this.reserved, bitIndex) == 1;
    }

    public void setReservedBit(int bitIndex) {
        if (bitIndex < 0 || bitIndex > 63) {
            throw new BtException("Illegal bit index: " + bitIndex + ". Expected index in range [0.." + 63 + "]");
        }
        Protocols.setBit(this.reserved, bitIndex);
    }

    public byte[] getReserved() {
        return this.reserved;
    }

    public TorrentId getTorrentId() {
        return this.torrentId;
    }

    public PeerId getPeerId() {
        return this.peerId;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "]";
    }

    @Override
    public Integer getMessageId() {
        throw new UnsupportedOperationException();
    }
}

