/*
 * Decompiled with CFR 0.152.
 */
package bt.protocol;

import bt.BtException;
import bt.metainfo.TorrentId;
import bt.peer.IPeerRegistry;
import bt.protocol.Handshake;
import bt.protocol.IHandshakeFactory;
import bt.protocol.InvalidMessageException;
import com.google.inject.Inject;
import com.google.inject.Provider;

public class HandshakeFactory
implements IHandshakeFactory {
    private static final int HANDSHAKE_RESERVED_LENGTH = 8;
    private Provider<IPeerRegistry> peerRegistry;

    @Inject
    public HandshakeFactory(Provider<IPeerRegistry> peerRegistry) {
        this.peerRegistry = peerRegistry;
    }

    @Override
    public Handshake createHandshake(TorrentId torrentId) {
        try {
            return new Handshake(new byte[8], torrentId, ((IPeerRegistry)this.peerRegistry.get()).getLocalPeer().getPeerId().orElseThrow(() -> new BtException("Local peer is missing ID")));
        }
        catch (InvalidMessageException e) {
            throw new BtException("Failed to create handshake", e);
        }
    }
}

