/*
 * Decompiled with CFR 0.152.
 */
package bt.protocol;

import bt.protocol.InvalidMessageException;
import bt.protocol.Message;

public final class Piece
implements Message {
    private int pieceIndex;
    private int offset;
    private byte[] block;

    public Piece(int pieceIndex, int offset, byte[] block) throws InvalidMessageException {
        if (pieceIndex < 0 || offset < 0 || block.length == 0) {
            throw new InvalidMessageException("Invalid arguments: piece index (" + pieceIndex + "), offset (" + offset + "), block length (" + block.length + ")");
        }
        this.pieceIndex = pieceIndex;
        this.offset = offset;
        this.block = block;
    }

    public int getPieceIndex() {
        return this.pieceIndex;
    }

    public int getOffset() {
        return this.offset;
    }

    public byte[] getBlock() {
        return this.block;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "] piece index {" + this.pieceIndex + "}, offset {" + this.offset + "}, block {" + this.block.length + " bytes}";
    }

    @Override
    public Integer getMessageId() {
        return 7;
    }
}

