/*
 * Decompiled with CFR 0.152.
 */
package bt.protocol;

import bt.BtException;
import bt.protocol.InvalidMessageException;
import bt.protocol.Message;
import java.nio.ByteBuffer;

public class Protocols {
    public static byte[] getLongBytes(long l) {
        return new byte[]{(byte)(l >> 56), (byte)(l >> 48), (byte)(l >> 40), (byte)(l >> 32), (byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l};
    }

    public static byte[] getIntBytes(int i) {
        return new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
    }

    public static byte[] getShortBytes(int s) {
        return new byte[]{(byte)(s >> 8), (byte)s};
    }

    public static long readLong(byte[] bytes, int offset) {
        if (bytes.length < offset + 8) {
            throw new ArrayIndexOutOfBoundsException("insufficient byte array length (length: " + bytes.length + ", offset: " + offset + ")");
        }
        return ((long)bytes[offset] & 0xFFL) << 56 | ((long)bytes[offset + 1] & 0xFFL) << 48 | ((long)bytes[offset + 2] & 0xFFL) << 40 | ((long)bytes[offset + 3] & 0xFFL) << 32 | ((long)bytes[offset + 4] & 0xFFL) << 24 | (long)((bytes[offset + 5] & 0xFF) << 16) | (long)((bytes[offset + 6] & 0xFF) << 8) | (long)(bytes[offset + 7] & 0xFF);
    }

    public static Long readLong(ByteBuffer buffer) {
        if (buffer.remaining() < 8) {
            return null;
        }
        return buffer.getLong();
    }

    public static int readInt(byte[] bytes, int offset) {
        if (bytes.length < offset + 4) {
            throw new ArrayIndexOutOfBoundsException("insufficient byte array length (length: " + bytes.length + ", offset: " + offset + ")");
        }
        return (bytes[offset] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    public static Integer readInt(ByteBuffer buffer) {
        if (buffer.remaining() < 4) {
            return null;
        }
        return buffer.getInt();
    }

    public static short readShort(byte[] bytes, int offset) {
        if (bytes.length < offset + 2) {
            throw new ArrayIndexOutOfBoundsException("insufficient byte array length (length: " + bytes.length + ", offset: " + offset + ")");
        }
        return (short)((bytes[offset] & 0xFF) << 8 | bytes[offset + 1] & 0xFF);
    }

    public static Short readShort(ByteBuffer buffer) {
        if (buffer.remaining() < 2) {
            return null;
        }
        return buffer.getShort();
    }

    public static void verifyPayloadHasLength(Class<? extends Message> type, int expectedLength, int actualLength) {
        if (expectedLength != actualLength) {
            throw new InvalidMessageException("Unexpected payload length for " + type.getSimpleName() + ": " + actualLength + " (expected " + expectedLength + ")");
        }
    }

    public static void setBit(byte[] bytes, int i) {
        int byteIndex = (int)((double)i / 8.0);
        if (byteIndex >= bytes.length) {
            throw new BtException("bit index is too large: " + i);
        }
        int bitIndex = i % 8;
        int shift = 7 - bitIndex;
        int bitMask = 1 << shift;
        byte currentByte = bytes[byteIndex];
        bytes[byteIndex] = (byte)(currentByte | bitMask);
    }

    public static int getBit(byte[] bytes, int i) {
        int byteIndex = (int)((double)i / 8.0);
        if (byteIndex >= bytes.length) {
            throw new BtException("bit index is too large: " + i);
        }
        int bitIndex = i % 8;
        int shift = 7 - bitIndex;
        int bitMask = 1 << shift;
        return (bytes[byteIndex] & bitMask) >> shift;
    }

    public static String toHex(byte[] bytes) {
        if (bytes.length == 0) {
            throw new IllegalArgumentException("Empty array");
        }
        char[] chars = new char[bytes.length * 2];
        int i = 0;
        int j = 0;
        while (i < bytes.length) {
            int b = bytes[i] & 0xFF;
            chars[j] = Protocols.forHexDigit(b / 16);
            chars[j + 1] = Protocols.forHexDigit(b % 16);
            j = ++i * 2;
        }
        return new String(chars);
    }

    private static char forHexDigit(int b) {
        if (b < 0 || b >= 16) {
            throw new IllegalArgumentException("Illegal hexadecimal digit: " + b);
        }
        return b < 10 ? (char)(48 + b) : (char)(97 + b - 10);
    }

    public static byte[] fromHex(String s) {
        if (s.isEmpty() || s.length() % 2 != 0) {
            throw new IllegalArgumentException("Invalid string: " + s);
        }
        char[] chars = s.toCharArray();
        int len = chars.length / 2;
        byte[] bytes = new byte[len];
        int i = 0;
        int j = 0;
        while (i < len) {
            bytes[i] = (byte)(Protocols.hexDigit(chars[j]) * 16 + Protocols.hexDigit(chars[j + 1]));
            j = ++i * 2;
        }
        return bytes;
    }

    private static int hexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException("Illegal hexadecimal character: " + c);
    }
}

