/*
 * Decompiled with CFR 0.152.
 */
package bt.protocol;

import bt.BtException;
import bt.metainfo.TorrentId;
import bt.module.MessageHandlers;
import bt.net.PeerId;
import bt.protocol.DecodingContext;
import bt.protocol.EncodingContext;
import bt.protocol.Handshake;
import bt.protocol.InvalidMessageException;
import bt.protocol.KeepAlive;
import bt.protocol.Message;
import bt.protocol.Protocols;
import bt.protocol.handler.BitfieldHandler;
import bt.protocol.handler.CancelHandler;
import bt.protocol.handler.ChokeHandler;
import bt.protocol.handler.HaveHandler;
import bt.protocol.handler.InterestedHandler;
import bt.protocol.handler.MessageHandler;
import bt.protocol.handler.NotInterestedHandler;
import bt.protocol.handler.PieceHandler;
import bt.protocol.handler.RequestHandler;
import bt.protocol.handler.UnchokeHandler;
import com.google.inject.Inject;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class StandardBittorrentProtocol
implements MessageHandler<Message> {
    public static final int MESSAGE_LENGTH_PREFIX_SIZE = 4;
    public static final int MESSAGE_TYPE_SIZE = 1;
    public static final int MESSAGE_PREFIX_SIZE = 5;
    public static final int CHOKE_ID = 0;
    public static final int UNCHOKE_ID = 1;
    public static final int INTERESTED_ID = 2;
    public static final int NOT_INTERESTED_ID = 3;
    public static final int HAVE_ID = 4;
    public static final int BITFIELD_ID = 5;
    public static final int REQUEST_ID = 6;
    public static final int PIECE_ID = 7;
    public static final int CANCEL_ID = 8;
    private static final String PROTOCOL_NAME = "BitTorrent protocol";
    private static final byte[] PROTOCOL_NAME_BYTES;
    private static final byte[] HANDSHAKE_PREFIX;
    private static final int HANDSHAKE_RESERVED_OFFSET;
    private static final int HANDSHAKE_RESERVED_LENGTH = 8;
    private static final byte[] KEEPALIVE;
    private Map<Integer, MessageHandler<?>> handlers;
    private Map<Integer, Class<? extends Message>> uniqueTypes;
    private Map<Class<? extends Message>, MessageHandler<?>> handlersByType;
    private Map<Class<? extends Message>, Integer> idMap;

    @Inject
    public StandardBittorrentProtocol(@MessageHandlers Map<Integer, MessageHandler<?>> extraHandlers) {
        HashMap handlers = new HashMap();
        handlers.put(0, new ChokeHandler());
        handlers.put(1, new UnchokeHandler());
        handlers.put(2, new InterestedHandler());
        handlers.put(3, new NotInterestedHandler());
        handlers.put(4, new HaveHandler());
        handlers.put(5, new BitfieldHandler());
        handlers.put(6, new RequestHandler());
        handlers.put(7, new PieceHandler());
        handlers.put(8, new CancelHandler());
        extraHandlers.forEach((messageId, handler) -> {
            if (handlers.containsKey(messageId)) {
                throw new BtException("Duplicate handler for message ID: " + messageId);
            }
            handlers.put((Integer)messageId, (MessageHandler<?>)handler);
        });
        HashMap<Class<? extends Message>, Integer> idMap = new HashMap<Class<? extends Message>, Integer>();
        HashMap handlersByType = new HashMap();
        HashMap<Integer, Class<? extends Message>> uniqueTypes = new HashMap<Integer, Class<? extends Message>>();
        handlers.forEach((messageId, handler) -> {
            if (handler.getSupportedTypes().isEmpty()) {
                throw new BtException("No supported types declared in handler: " + handler.getClass().getName());
            }
            uniqueTypes.put((Integer)messageId, handler.getSupportedTypes().iterator().next());
            handler.getSupportedTypes().forEach(messageType -> {
                if (idMap.containsKey(messageType)) {
                    throw new BtException("Duplicate handler for message type: " + messageType.getSimpleName());
                }
                idMap.put((Class<? extends Message>)messageType, (Integer)messageId);
                handlersByType.put((Class<? extends Message>)messageType, (MessageHandler<?>)handler);
            });
        });
        this.handlers = handlers;
        this.idMap = idMap;
        this.handlersByType = handlersByType;
        this.uniqueTypes = uniqueTypes;
    }

    @Override
    public Collection<Class<? extends Message>> getSupportedTypes() {
        return null;
    }

    @Override
    public final Class<? extends Message> readMessageType(ByteBuffer buffer) {
        Objects.requireNonNull(buffer);
        if (!buffer.hasRemaining()) {
            return null;
        }
        int position = buffer.position();
        byte first = buffer.get();
        if (first == PROTOCOL_NAME.length()) {
            return Handshake.class;
        }
        buffer.position(position);
        Integer length = Protocols.readInt(buffer);
        if (length == null) {
            return null;
        }
        if (length == 0) {
            return KeepAlive.class;
        }
        if (buffer.hasRemaining()) {
            byte messageTypeId = buffer.get();
            Class<Message> messageType = this.uniqueTypes.get(messageTypeId);
            if (messageType == null) {
                MessageHandler<?> handler = this.handlers.get(messageTypeId);
                if (handler == null) {
                    throw new InvalidMessageException("Unknown message type ID: " + messageTypeId);
                }
                messageType = handler.readMessageType(buffer);
            }
            return messageType;
        }
        return null;
    }

    @Override
    public final int decode(DecodingContext context, ByteBuffer buffer) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(buffer);
        if (!buffer.hasRemaining()) {
            return 0;
        }
        int position = buffer.position();
        Class<? extends Message> messageType = this.readMessageType(buffer);
        if (messageType == null) {
            return 0;
        }
        if (Handshake.class.equals(messageType)) {
            buffer.position(position);
            return StandardBittorrentProtocol.decodeHandshake(context, buffer);
        }
        if (KeepAlive.class.equals(messageType)) {
            context.setMessage(KeepAlive.instance());
            return KEEPALIVE.length;
        }
        MessageHandler<?> handler = Objects.requireNonNull(this.handlersByType.get(messageType));
        buffer.position(position);
        return handler.decode(context, buffer);
    }

    @Override
    public final boolean encode(EncodingContext context, Message message, ByteBuffer buffer) {
        Objects.requireNonNull(buffer);
        Integer messageId = this.idMap.get(Objects.requireNonNull(message).getClass());
        if (Handshake.class.equals(message.getClass())) {
            Handshake handshake = (Handshake)message;
            return StandardBittorrentProtocol.writeHandshake(buffer, handshake.getReserved(), handshake.getTorrentId(), handshake.getPeerId());
        }
        if (KeepAlive.class.equals(message.getClass())) {
            return StandardBittorrentProtocol.writeKeepAlive(buffer);
        }
        if (messageId == null) {
            throw new InvalidMessageException("Unknown message type: " + message.getClass().getSimpleName());
        }
        return this.handlers.get(messageId).encode(context, message, buffer);
    }

    private static boolean writeKeepAlive(ByteBuffer buffer) {
        if (buffer.remaining() < KEEPALIVE.length) {
            return false;
        }
        buffer.put(KEEPALIVE);
        return true;
    }

    private static boolean writeHandshake(ByteBuffer buffer, byte[] reserved, TorrentId torrentId, PeerId peerId) {
        if (reserved.length != 8) {
            throw new InvalidMessageException("Invalid reserved bytes: expected 8 bytes, received " + reserved.length);
        }
        int length = HANDSHAKE_PREFIX.length + 8 + TorrentId.length() + PeerId.length();
        if (buffer.remaining() < length) {
            return false;
        }
        buffer.put(HANDSHAKE_PREFIX);
        buffer.put(reserved);
        buffer.put(torrentId.getBytes());
        buffer.put(peerId.getBytes());
        return true;
    }

    private static int decodeHandshake(DecodingContext context, ByteBuffer buffer) {
        int consumed = 0;
        int offset = HANDSHAKE_RESERVED_OFFSET;
        int length = 8 + TorrentId.length() + PeerId.length();
        int limit = offset + length;
        if (buffer.remaining() >= limit) {
            buffer.get();
            byte[] protocolNameBytes = new byte[PROTOCOL_NAME.length()];
            buffer.get(protocolNameBytes);
            if (!Arrays.equals(PROTOCOL_NAME_BYTES, protocolNameBytes)) {
                throw new InvalidMessageException("Unexpected protocol name (decoded with ASCII): " + new String(protocolNameBytes, Charset.forName("ASCII")));
            }
            byte[] reserved = new byte[8];
            buffer.get(reserved);
            byte[] infoHash = new byte[TorrentId.length()];
            buffer.get(infoHash);
            byte[] peerId = new byte[PeerId.length()];
            buffer.get(peerId);
            context.setMessage(new Handshake(reserved, TorrentId.fromBytes(infoHash), PeerId.fromBytes(peerId)));
            consumed = limit;
        }
        return consumed;
    }

    static {
        KEEPALIVE = new byte[]{0, 0, 0, 0};
        PROTOCOL_NAME_BYTES = PROTOCOL_NAME.getBytes(Charset.forName("ASCII"));
        int protocolNameLength = PROTOCOL_NAME_BYTES.length;
        int prefixLength = 1;
        HANDSHAKE_RESERVED_OFFSET = 1 + protocolNameLength;
        HANDSHAKE_PREFIX = new byte[HANDSHAKE_RESERVED_OFFSET];
        StandardBittorrentProtocol.HANDSHAKE_PREFIX[0] = (byte)protocolNameLength;
        System.arraycopy(PROTOCOL_NAME_BYTES, 0, HANDSHAKE_PREFIX, prefixLength, protocolNameLength);
    }
}

