/*
 * Decompiled with CFR 0.152.
 */
package bt.protocol.crypto;

import bt.BtException;
import bt.metainfo.TorrentId;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class MSECipher {
    private static final String transformation = "ARCFOUR/ECB/NoPadding";
    private final Cipher incomingCipher;
    private final Cipher outgoingCipher;

    public static boolean isKeySizeSupported(int keySize) throws BtException {
        int maxAllowedKeySizeBits;
        if (keySize <= 0) {
            throw new IllegalArgumentException("Negative key size: " + keySize);
        }
        try {
            maxAllowedKeySizeBits = Cipher.getMaxAllowedKeyLength(transformation);
        }
        catch (NoSuchAlgorithmException e) {
            throw new BtException("Transformation is not supported: ARCFOUR/ECB/NoPadding");
        }
        return keySize * 8 <= maxAllowedKeySizeBits;
    }

    public static MSECipher forInitiator(byte[] S, TorrentId torrentId) {
        return new MSECipher(S, torrentId, true);
    }

    public static MSECipher forReceiver(byte[] S, TorrentId torrentId) {
        return new MSECipher(S, torrentId, false);
    }

    private MSECipher(byte[] S, TorrentId torrentId, boolean initiator) {
        Key initiatorKey = this.getInitiatorEncryptionKey(S, torrentId.getBytes());
        Key receiverKey = this.getReceiverEncryptionKey(S, torrentId.getBytes());
        Key outgoingKey = initiator ? initiatorKey : receiverKey;
        Key incomingKey = initiator ? receiverKey : initiatorKey;
        this.incomingCipher = this.createCipher(2, transformation, incomingKey);
        this.outgoingCipher = this.createCipher(1, transformation, outgoingKey);
    }

    public Cipher getEncryptionCipher() {
        return this.outgoingCipher;
    }

    public Cipher getDecryptionCipher() {
        return this.incomingCipher;
    }

    private Key getInitiatorEncryptionKey(byte[] S, byte[] SKEY) {
        return this.getEncryptionKey("keyA", S, SKEY);
    }

    private Key getReceiverEncryptionKey(byte[] S, byte[] SKEY) {
        return this.getEncryptionKey("keyB", S, SKEY);
    }

    private Key getEncryptionKey(String s, byte[] S, byte[] SKEY) {
        MessageDigest digest = this.getDigest("SHA-1");
        digest.update(s.getBytes(Charset.forName("ASCII")));
        digest.update(S);
        digest.update(SKEY);
        return new SecretKeySpec(digest.digest(), "ARCFOUR");
    }

    private MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private Cipher createCipher(int mode, String transformation, Key key) {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance(transformation);
            cipher.init(mode, key);
            cipher.update(new byte[1024]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return cipher;
    }
}

