/*
 * Decompiled with CFR 0.152.
 */
package bt.protocol.extended;

import bt.protocol.extended.ExtendedMessage;
import bt.protocol.extended.ExtendedMessageTypeMapping;
import bt.protocol.handler.MessageHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.BiConsumer;

public class AlphaSortedMapping
implements ExtendedMessageTypeMapping {
    private Map<Integer, String> nameMap;
    private Map<String, Integer> idMap;
    private Map<Class<?>, String> typeMap = new HashMap();

    public AlphaSortedMapping(Map<String, MessageHandler<? extends ExtendedMessage>> handlersByTypeName) {
        TreeSet sortedTypeNames = new TreeSet();
        handlersByTypeName.forEach((typeName, handler) -> {
            sortedTypeNames.add(typeName);
            handler.getSupportedTypes().forEach(messageType -> this.typeMap.put((Class<?>)messageType, (String)typeName));
        });
        this.nameMap = new HashMap<Integer, String>();
        this.idMap = new HashMap<String, Integer>();
        Integer localTypeId = 1;
        for (String typeName2 : sortedTypeNames) {
            this.nameMap.put(localTypeId, typeName2);
            this.idMap.put(typeName2, localTypeId);
            Integer n = localTypeId;
            Integer n2 = localTypeId = Integer.valueOf(localTypeId + 1);
        }
    }

    @Override
    public String getTypeNameForId(Integer typeId) {
        return this.nameMap.get(Objects.requireNonNull(typeId));
    }

    @Override
    public Integer getIdForTypeName(String typeName) {
        return this.idMap.get(Objects.requireNonNull(typeName));
    }

    @Override
    public String getTypeNameForJavaType(Class<?> type) {
        return this.typeMap.get(Objects.requireNonNull(type));
    }

    @Override
    public void visitMappings(BiConsumer<String, Integer> visitor) {
        Objects.requireNonNull(visitor);
        this.nameMap.forEach((id, name) -> visitor.accept((String)name, (Integer)id));
    }
}

