/*
 * Decompiled with CFR 0.152.
 */
package bt.protocol.extended;

import bt.BtException;
import bt.bencoding.model.BEInteger;
import bt.bencoding.model.BEMap;
import bt.bencoding.model.BEObject;
import bt.protocol.extended.ExtendedMessage;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class ExtendedHandshake
extends ExtendedMessage {
    public static final String MESSAGE_TYPE_MAPPING_KEY = "m";
    private Map<String, BEObject<?>> data;
    private Set<String> supportedMessageTypes;

    public static Builder builder() {
        return new Builder();
    }

    ExtendedHandshake(Map<String, BEObject<?>> data) {
        this.data = Collections.unmodifiableMap(data);
        BEMap supportedMessageTypes = (BEMap)data.get(MESSAGE_TYPE_MAPPING_KEY);
        this.supportedMessageTypes = supportedMessageTypes != null ? Collections.unmodifiableSet(supportedMessageTypes.getValue().keySet()) : Collections.emptySet();
    }

    public Map<String, BEObject<?>> getData() {
        return this.data;
    }

    public Set<String> getSupportedMessageTypes() {
        return this.supportedMessageTypes;
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "] supported messages {" + this.supportedMessageTypes + "}, data {" + this.data + "}";
    }

    public static class Builder {
        private Map<String, BEObject<?>> messageTypeMap;
        private Map<String, BEObject<?>> data = new HashMap();

        private Builder() {
        }

        public Builder property(String name, BEObject<?> value) {
            Objects.requireNonNull(name);
            if (ExtendedHandshake.MESSAGE_TYPE_MAPPING_KEY.equals(name)) {
                throw new IllegalArgumentException("Property name is reserved: m");
            }
            Objects.requireNonNull(value);
            this.data.put(name, value);
            return this;
        }

        public Builder addMessageType(String typeName, Integer typeId) {
            if (this.messageTypeMap == null) {
                this.messageTypeMap = new HashMap();
            }
            if (this.messageTypeMap.containsKey(Objects.requireNonNull(typeName))) {
                throw new BtException("Message type already defined: " + typeName);
            }
            this.messageTypeMap.put(typeName, (BEObject<?>)new BEInteger(null, BigInteger.valueOf(typeId.intValue())));
            return this;
        }

        public ExtendedHandshake build() {
            if (this.messageTypeMap != null) {
                this.data.put(ExtendedHandshake.MESSAGE_TYPE_MAPPING_KEY, (BEObject<?>)new BEMap(null, this.messageTypeMap));
            }
            return new ExtendedHandshake(this.data);
        }
    }
}

