/*
 * Decompiled with CFR 0.152.
 */
package bt.protocol.extended;

import bt.bencoding.model.BEInteger;
import bt.bencoding.model.BEObject;
import bt.bencoding.model.BEString;
import bt.metainfo.TorrentId;
import bt.protocol.IExtendedHandshakeFactory;
import bt.protocol.crypto.EncryptionPolicy;
import bt.protocol.extended.ExtendedHandshake;
import bt.protocol.extended.ExtendedMessageTypeMapping;
import bt.runtime.Config;
import bt.service.ApplicationService;
import bt.torrent.TorrentRegistry;
import com.google.inject.Inject;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedHandshakeFactory
implements IExtendedHandshakeFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedHandshakeFactory.class);
    private static final String ENCRYPTION_PROPERTY = "e";
    private static final String TCPPORT_PROPERTY = "p";
    private static final String VERSION_PROPERTY = "v";
    private static final String UT_METADATA_SIZE_PROPERTY = "metadata_size";
    private static final String VERSION_TEMPLATE = "Bt %s";
    private final TorrentRegistry torrentRegistry;
    private final ExtendedMessageTypeMapping messageTypeMapping;
    private final ApplicationService applicationService;
    private final EncryptionPolicy encryptionPolicy;
    private final int tcpAcceptorPort;
    private final ConcurrentMap<TorrentId, ExtendedHandshake> extendedHandshakes;

    @Inject
    public ExtendedHandshakeFactory(TorrentRegistry torrentRegistry, ExtendedMessageTypeMapping messageTypeMapping, ApplicationService applicationService, Config config) {
        this.torrentRegistry = torrentRegistry;
        this.messageTypeMapping = messageTypeMapping;
        this.applicationService = applicationService;
        this.encryptionPolicy = config.getEncryptionPolicy();
        this.tcpAcceptorPort = config.getAcceptorPort();
        this.extendedHandshakes = new ConcurrentHashMap<TorrentId, ExtendedHandshake>();
    }

    @Override
    public ExtendedHandshake getHandshake(TorrentId torrentId) {
        ExtendedHandshake existing;
        ExtendedHandshake handshake = (ExtendedHandshake)this.extendedHandshakes.get(torrentId);
        if (handshake == null && (existing = this.extendedHandshakes.putIfAbsent(torrentId, handshake = this.buildHandshake(torrentId))) != null) {
            handshake = existing;
        }
        return handshake;
    }

    private ExtendedHandshake buildHandshake(TorrentId torrentId) {
        String version;
        ExtendedHandshake.Builder builder = ExtendedHandshake.builder();
        switch (this.encryptionPolicy) {
            case REQUIRE_PLAINTEXT: 
            case PREFER_PLAINTEXT: {
                builder.property(ENCRYPTION_PROPERTY, (BEObject<?>)new BEInteger(null, BigInteger.ZERO));
            }
            case PREFER_ENCRYPTED: 
            case REQUIRE_ENCRYPTED: {
                builder.property(ENCRYPTION_PROPERTY, (BEObject<?>)new BEInteger(null, BigInteger.ONE));
            }
        }
        builder.property(TCPPORT_PROPERTY, (BEObject<?>)new BEInteger(null, BigInteger.valueOf(this.tcpAcceptorPort)));
        try {
            this.torrentRegistry.getTorrent(torrentId).ifPresent(torrent -> {
                int metadataSize = torrent.getSource().getExchangedMetadata().length;
                builder.property(UT_METADATA_SIZE_PROPERTY, (BEObject<?>)new BEInteger(null, BigInteger.valueOf(metadataSize)));
            });
        }
        catch (Exception e) {
            LOGGER.error("Failed to get metadata size for torrent ID: " + torrentId, (Throwable)e);
        }
        try {
            version = this.getVersion();
        }
        catch (Exception e) {
            LOGGER.error("Failed to get version", (Throwable)e);
            version = this.getDefaultVersion();
        }
        builder.property(VERSION_PROPERTY, (BEObject<?>)new BEString(version.getBytes(Charset.forName("UTF-8"))));
        this.messageTypeMapping.visitMappings(builder::addMessageType);
        return builder.build();
    }

    protected String getVersion() {
        return String.format(VERSION_TEMPLATE, this.applicationService.getVersion());
    }

    private String getDefaultVersion() {
        return String.format(VERSION_TEMPLATE, "(unknown version)");
    }
}

