/*
 * Decompiled with CFR 0.152.
 */
package bt.protocol.extended;

import bt.BtException;
import bt.bencoding.BEParser;
import bt.bencoding.BEType;
import bt.bencoding.model.BEInteger;
import bt.bencoding.model.BEMap;
import bt.bencoding.model.BEObject;
import bt.net.Peer;
import bt.protocol.DecodingContext;
import bt.protocol.EncodingContext;
import bt.protocol.InvalidMessageException;
import bt.protocol.extended.ExtendedHandshake;
import bt.protocol.handler.MessageHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class ExtendedHandshakeMessageHandler
implements MessageHandler<ExtendedHandshake> {
    private Collection<Class<? extends ExtendedHandshake>> supportedTypes;
    private ConcurrentMap<Peer, Map<Integer, String>> peerTypeMappings = new ConcurrentHashMap<Peer, Map<Integer, String>>();

    ExtendedHandshakeMessageHandler() {
        this.supportedTypes = Collections.singleton(ExtendedHandshake.class);
    }

    @Override
    public Collection<Class<? extends ExtendedHandshake>> getSupportedTypes() {
        return this.supportedTypes;
    }

    @Override
    public Class<? extends ExtendedHandshake> readMessageType(ByteBuffer buffer) {
        return ExtendedHandshake.class;
    }

    private void processTypeMapping(Peer peer, BEObject mappingObj) {
        if (mappingObj == null) {
            return;
        }
        if (mappingObj.getType() != BEType.MAP) {
            throw new InvalidMessageException("Extended message types mapping must be a dictionary. Actual BE type: " + mappingObj.getType().name());
        }
        Map mapping = (Map)mappingObj.getValue();
        if (mapping.size() > 0) {
            this.peerTypeMappings.put(peer, this.mergeMappings(this.peerTypeMappings.getOrDefault(peer, new HashMap()), mapping));
        }
    }

    Map<Integer, String> getPeerTypeMapping(Peer peer) {
        Map mapping = (Map)this.peerTypeMappings.get(peer);
        return mapping == null ? Collections.emptyMap() : Collections.unmodifiableMap(mapping);
    }

    private Map<Integer, String> mergeMappings(Map<Integer, String> existing, Map<String, BEObject> changes) {
        block0: for (Map.Entry<String, BEObject> entry : changes.entrySet()) {
            String typeName = entry.getKey();
            Integer typeId = ((BEInteger)entry.getValue()).getValue().intValue();
            if (typeId == 0) {
                Iterator<Integer> iter = existing.keySet().iterator();
                while (iter.hasNext()) {
                    Integer key = iter.next();
                    if (!typeName.equals(existing.get(key))) continue;
                    iter.remove();
                    continue block0;
                }
                continue;
            }
            existing.put(typeId, typeName);
        }
        return existing;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int decode(DecodingContext context, ByteBuffer buffer) {
        byte[] payload = new byte[buffer.remaining()];
        buffer.get(payload);
        try (BEParser parser = new BEParser(payload);){
            BEMap message = parser.readMap();
            Map value = message.getValue();
            this.processTypeMapping(context.getPeer(), (BEObject)value.get("m"));
            context.setMessage(new ExtendedHandshake(value));
            int n = message.getContent().length;
            return n;
        }
        catch (Exception e) {
            throw new BtException("Failed to decode extended handshake", e);
        }
    }

    @Override
    public boolean encode(EncodingContext context, ExtendedHandshake message, ByteBuffer buffer) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            new BEMap(null, message.getData()).writeTo((OutputStream)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] payload = out.toByteArray();
        if (buffer.remaining() < payload.length) {
            return false;
        }
        buffer.put(payload);
        return true;
    }
}

