/*
 * Decompiled with CFR 0.152.
 */
package bt.protocol.extended;

import bt.BtException;
import bt.module.ExtendedMessageHandlers;
import bt.protocol.DecodingContext;
import bt.protocol.EncodingContext;
import bt.protocol.InvalidMessageException;
import bt.protocol.Message;
import bt.protocol.extended.ExtendedHandshake;
import bt.protocol.extended.ExtendedHandshakeMessageHandler;
import bt.protocol.extended.ExtendedMessage;
import bt.protocol.extended.ExtendedMessageTypeMapping;
import bt.protocol.handler.BaseMessageHandler;
import bt.protocol.handler.MessageHandler;
import com.google.inject.Inject;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ExtendedProtocol
extends BaseMessageHandler<ExtendedMessage> {
    public static final int EXTENDED_MESSAGE_ID = 20;
    private static final int HANDSHAKE_TYPE_ID = 0;
    private ExtendedHandshakeMessageHandler extendedHandshakeHandler;
    private Map<Class<? extends ExtendedMessage>, MessageHandler<? extends ExtendedMessage>> handlers;
    private Map<String, Class<? extends ExtendedMessage>> uniqueTypes;
    private Map<String, MessageHandler<? extends ExtendedMessage>> handlersByTypeName;
    private ExtendedMessageTypeMapping messageTypeMapping;

    @Inject
    public ExtendedProtocol(ExtendedMessageTypeMapping messageTypeMapping, @ExtendedMessageHandlers Map<String, MessageHandler<? extends ExtendedMessage>> handlersByTypeName) {
        this.messageTypeMapping = messageTypeMapping;
        HashMap<Class<ExtendedHandshake>, ExtendedHandshakeMessageHandler> handlers = new HashMap<Class<ExtendedHandshake>, ExtendedHandshakeMessageHandler>();
        this.extendedHandshakeHandler = new ExtendedHandshakeMessageHandler();
        handlers.put(ExtendedHandshake.class, this.extendedHandshakeHandler);
        HashMap<String, Class<? extends ExtendedMessage>> uniqueTypes = new HashMap<String, Class<? extends ExtendedMessage>>();
        handlersByTypeName.forEach((typeName, handler) -> {
            if (handler.getSupportedTypes().isEmpty()) {
                throw new BtException("No supported types declared in handler: " + handler.getClass().getName());
            }
            uniqueTypes.put((String)typeName, handler.getSupportedTypes().iterator().next());
            handler.getSupportedTypes().forEach(messageType -> {
                if (handlers.keySet().contains(messageType)) {
                    throw new BtException("Encountered duplicate handler for message type: " + messageType.getSimpleName());
                }
                handlers.put((Class<ExtendedHandshake>)messageType, (ExtendedHandshakeMessageHandler)handler);
            });
        });
        this.handlers = Collections.unmodifiableMap(handlers);
        this.handlersByTypeName = handlersByTypeName;
        this.uniqueTypes = uniqueTypes;
    }

    @Override
    public Collection<Class<? extends ExtendedMessage>> getSupportedTypes() {
        return this.handlers.keySet();
    }

    @Override
    public Class<? extends ExtendedMessage> readMessageType(ByteBuffer buffer) {
        if (!buffer.hasRemaining()) {
            return null;
        }
        Integer messageTypeId = buffer.get();
        if (messageTypeId == 0) {
            return ExtendedHandshake.class;
        }
        String typeName = this.messageTypeMapping.getTypeNameForId(messageTypeId);
        if (typeName == null) {
            throw new InvalidMessageException("Unknown message type ID: " + messageTypeId);
        }
        Class<ExtendedMessage> messageType = this.uniqueTypes.get(typeName);
        if (messageType == null) {
            messageType = this.handlersByTypeName.get(typeName).readMessageType(buffer);
        }
        return messageType;
    }

    @Override
    public int doDecode(DecodingContext context, ByteBuffer buffer) {
        MessageHandler<ExtendedHandshake> handler;
        byte typeId = buffer.get();
        if (typeId == 0) {
            handler = this.extendedHandshakeHandler;
        } else {
            String extendedType = this.messageTypeMapping.getTypeNameForId(Integer.valueOf(typeId));
            if (extendedType == null) {
                throw new BtException("Received unsupported extended message id: " + typeId);
            }
            handler = this.handlersByTypeName.get(extendedType);
        }
        int consumed = handler.decode(context, buffer);
        if (consumed > 0) {
            ++consumed;
        }
        return consumed;
    }

    @Override
    public boolean doEncode(EncodingContext context, ExtendedMessage message, ByteBuffer buffer) {
        Class<?> messageType = message.getClass();
        return this.doEncode(context, message, messageType, buffer);
    }

    private <T extends Message> boolean doEncode(EncodingContext context, Message message, Class<T> messageType, ByteBuffer buffer) {
        if (!buffer.hasRemaining()) {
            return false;
        }
        int begin = buffer.position();
        if (ExtendedHandshake.class.equals(messageType)) {
            buffer.put((byte)0);
        } else {
            String typeName = this.messageTypeMapping.getTypeNameForJavaType(messageType);
            if (typeName == null) {
                throw new IllegalStateException("Unknown message type: " + messageType.getName());
            }
            Integer typeId = null;
            for (Map.Entry<Integer, String> e : this.extendedHandshakeHandler.getPeerTypeMapping(context.getPeer()).entrySet()) {
                if (!e.getValue().equals(typeName)) continue;
                typeId = e.getKey();
            }
            if (typeId == null) {
                throw new IllegalStateException("Peer does not support extension message: " + typeName);
            }
            buffer.put(typeId.byteValue());
        }
        boolean encoded = this.handlers.get(messageType).encode(context, (ExtendedMessage)message, buffer);
        if (!encoded) {
            buffer.position(begin);
        }
        return encoded;
    }
}

