/*
 * Decompiled with CFR 0.152.
 */
package bt.protocol.handler;

import bt.BtException;
import bt.protocol.DecodingContext;
import bt.protocol.EncodingContext;
import bt.protocol.Message;
import bt.protocol.Protocols;
import bt.protocol.handler.MessageHandler;
import java.nio.ByteBuffer;
import java.util.Objects;

public abstract class BaseMessageHandler<T extends Message>
implements MessageHandler<T> {
    @Override
    public boolean encode(EncodingContext context, T message, ByteBuffer buffer) {
        if (buffer.remaining() < 5) {
            return false;
        }
        int begin = buffer.position();
        buffer.position(begin + 5);
        if (this.doEncode(context, message, buffer)) {
            int end = buffer.position();
            int payloadLength = end - begin - 5;
            if (payloadLength < 0) {
                throw new BtException("Unexpected payload length: " + payloadLength);
            }
            buffer.position(begin);
            buffer.putInt(payloadLength + 1);
            buffer.put(message.getMessageId().byteValue());
            buffer.position(end);
            return true;
        }
        buffer.position(begin);
        return false;
    }

    protected abstract boolean doEncode(EncodingContext var1, T var2, ByteBuffer var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int decode(DecodingContext context, ByteBuffer buffer) {
        if (buffer.remaining() < 5) {
            return 0;
        }
        Integer length = Objects.requireNonNull(Protocols.readInt(buffer));
        if (buffer.remaining() < length) {
            return 0;
        }
        buffer.get();
        int initialLimit = buffer.limit();
        buffer.limit(buffer.position() + length - 1);
        try {
            int consumed = this.doDecode(context, buffer);
            if (context.getMessage() != null) {
                int n = consumed + 5;
                return n;
            }
        }
        finally {
            buffer.limit(initialLimit);
        }
        return 0;
    }

    protected abstract int doDecode(DecodingContext var1, ByteBuffer var2);
}

