/*
 * Decompiled with CFR 0.152.
 */
package bt.protocol.handler;

import bt.protocol.Bitfield;
import bt.protocol.DecodingContext;
import bt.protocol.EncodingContext;
import bt.protocol.handler.UniqueMessageHandler;
import java.nio.ByteBuffer;

public final class BitfieldHandler
extends UniqueMessageHandler<Bitfield> {
    public BitfieldHandler() {
        super(Bitfield.class);
    }

    @Override
    public int doDecode(DecodingContext context, ByteBuffer buffer) {
        return BitfieldHandler.decodeBitfield(context, buffer, buffer.remaining());
    }

    @Override
    public boolean doEncode(EncodingContext context, Bitfield message, ByteBuffer buffer) {
        if (buffer.remaining() < message.getBitfield().length) {
            return false;
        }
        buffer.put(message.getBitfield());
        return true;
    }

    private static int decodeBitfield(DecodingContext context, ByteBuffer buffer, int length) {
        int consumed = 0;
        if (buffer.remaining() >= length) {
            byte[] bitfield = new byte[length];
            buffer.get(bitfield);
            context.setMessage(new Bitfield(bitfield));
            consumed = length;
        }
        return consumed;
    }
}

