/*
 * Decompiled with CFR 0.152.
 */
package bt.protocol.handler;

import bt.protocol.Cancel;
import bt.protocol.DecodingContext;
import bt.protocol.EncodingContext;
import bt.protocol.InvalidMessageException;
import bt.protocol.Protocols;
import bt.protocol.handler.UniqueMessageHandler;
import java.nio.ByteBuffer;
import java.util.Objects;

public final class CancelHandler
extends UniqueMessageHandler<Cancel> {
    public CancelHandler() {
        super(Cancel.class);
    }

    @Override
    public int doDecode(DecodingContext context, ByteBuffer buffer) {
        Protocols.verifyPayloadHasLength(Cancel.class, 12, buffer.remaining());
        return CancelHandler.decodeCancel(context, buffer);
    }

    @Override
    public boolean doEncode(EncodingContext context, Cancel message, ByteBuffer buffer) {
        return CancelHandler.writeCancel(message.getPieceIndex(), message.getOffset(), message.getLength(), buffer);
    }

    private static boolean writeCancel(int pieceIndex, int offset, int length, ByteBuffer buffer) {
        if (pieceIndex < 0 || offset < 0 || length <= 0) {
            throw new InvalidMessageException("Invalid arguments: pieceIndex (" + pieceIndex + "), offset (" + offset + "), length (" + length + ")");
        }
        if (buffer.remaining() < 12) {
            return false;
        }
        buffer.putInt(pieceIndex);
        buffer.putInt(offset);
        buffer.putInt(length);
        return true;
    }

    private static int decodeCancel(DecodingContext context, ByteBuffer buffer) {
        int consumed = 0;
        int length = 12;
        if (buffer.remaining() >= length) {
            int pieceIndex = Objects.requireNonNull(Protocols.readInt(buffer));
            int blockOffset = Objects.requireNonNull(Protocols.readInt(buffer));
            int blockLength = Objects.requireNonNull(Protocols.readInt(buffer));
            context.setMessage(new Cancel(pieceIndex, blockOffset, blockLength));
            consumed = length;
        }
        return consumed;
    }
}

