/*
 * Decompiled with CFR 0.152.
 */
package bt.protocol.handler;

import bt.protocol.DecodingContext;
import bt.protocol.EncodingContext;
import bt.protocol.Have;
import bt.protocol.InvalidMessageException;
import bt.protocol.Protocols;
import bt.protocol.handler.UniqueMessageHandler;
import java.nio.ByteBuffer;
import java.util.Objects;

public final class HaveHandler
extends UniqueMessageHandler<Have> {
    public HaveHandler() {
        super(Have.class);
    }

    @Override
    public int doDecode(DecodingContext context, ByteBuffer buffer) {
        Protocols.verifyPayloadHasLength(Have.class, 4, buffer.remaining());
        return HaveHandler.decodeHave(context, buffer);
    }

    @Override
    public boolean doEncode(EncodingContext context, Have message, ByteBuffer buffer) {
        return HaveHandler.writeHave(message.getPieceIndex(), buffer);
    }

    private static boolean writeHave(int pieceIndex, ByteBuffer buffer) {
        if (pieceIndex < 0) {
            throw new InvalidMessageException("Invalid piece index: " + pieceIndex);
        }
        if (buffer.remaining() < 4) {
            return false;
        }
        buffer.putInt(pieceIndex);
        return true;
    }

    private static int decodeHave(DecodingContext context, ByteBuffer buffer) {
        int consumed = 0;
        int length = 4;
        if (buffer.remaining() >= length) {
            Integer pieceIndex = Objects.requireNonNull(Protocols.readInt(buffer));
            context.setMessage(new Have(pieceIndex));
            consumed = length;
        }
        return consumed;
    }
}

