/*
 * Decompiled with CFR 0.152.
 */
package bt.protocol.handler;

import bt.protocol.DecodingContext;
import bt.protocol.EncodingContext;
import bt.protocol.InvalidMessageException;
import bt.protocol.Piece;
import bt.protocol.Protocols;
import bt.protocol.handler.UniqueMessageHandler;
import java.nio.ByteBuffer;
import java.util.Objects;

public final class PieceHandler
extends UniqueMessageHandler<Piece> {
    public PieceHandler() {
        super(Piece.class);
    }

    @Override
    public int doDecode(DecodingContext context, ByteBuffer buffer) {
        return PieceHandler.decodePiece(context, buffer, buffer.remaining());
    }

    @Override
    public boolean doEncode(EncodingContext context, Piece message, ByteBuffer buffer) {
        return PieceHandler.writePiece(message.getPieceIndex(), message.getOffset(), message.getBlock(), buffer);
    }

    private static boolean writePiece(int pieceIndex, int offset, byte[] block, ByteBuffer buffer) {
        if (pieceIndex < 0 || offset < 0) {
            throw new InvalidMessageException("Invalid arguments: pieceIndex (" + pieceIndex + "), offset (" + offset + ")");
        }
        if (block.length == 0) {
            throw new InvalidMessageException("Invalid block: empty");
        }
        if (buffer.remaining() < 8 + block.length) {
            return false;
        }
        buffer.putInt(pieceIndex);
        buffer.putInt(offset);
        buffer.put(block);
        return true;
    }

    private static int decodePiece(DecodingContext context, ByteBuffer buffer, int length) {
        int consumed = 0;
        if (buffer.remaining() >= length) {
            int pieceIndex = Objects.requireNonNull(Protocols.readInt(buffer));
            int blockOffset = Objects.requireNonNull(Protocols.readInt(buffer));
            byte[] block = new byte[length - 8];
            buffer.get(block);
            context.setMessage(new Piece(pieceIndex, blockOffset, block));
            consumed = length;
        }
        return consumed;
    }
}

