/*
 * Decompiled with CFR 0.152.
 */
package bt.protocol.handler;

import bt.protocol.DecodingContext;
import bt.protocol.EncodingContext;
import bt.protocol.InvalidMessageException;
import bt.protocol.Protocols;
import bt.protocol.Request;
import bt.protocol.handler.UniqueMessageHandler;
import java.nio.ByteBuffer;
import java.util.Objects;

public final class RequestHandler
extends UniqueMessageHandler<Request> {
    public RequestHandler() {
        super(Request.class);
    }

    @Override
    public int doDecode(DecodingContext context, ByteBuffer buffer) {
        Protocols.verifyPayloadHasLength(Request.class, 12, buffer.remaining());
        return RequestHandler.decodeRequest(context, buffer);
    }

    @Override
    public boolean doEncode(EncodingContext context, Request message, ByteBuffer buffer) {
        return RequestHandler.writeRequest(message.getPieceIndex(), message.getOffset(), message.getLength(), buffer);
    }

    private static boolean writeRequest(int pieceIndex, int offset, int length, ByteBuffer buffer) {
        if (pieceIndex < 0 || offset < 0 || length <= 0) {
            throw new InvalidMessageException("Invalid arguments: pieceIndex (" + pieceIndex + "), offset (" + offset + "), length (" + length + ")");
        }
        if (buffer.remaining() < 12) {
            return false;
        }
        buffer.putInt(pieceIndex);
        buffer.putInt(offset);
        buffer.putInt(length);
        return true;
    }

    private static int decodeRequest(DecodingContext context, ByteBuffer buffer) {
        int consumed = 0;
        int length = 12;
        if (buffer.remaining() >= length) {
            int pieceIndex = Objects.requireNonNull(Protocols.readInt(buffer));
            int blockOffset = Objects.requireNonNull(Protocols.readInt(buffer));
            int blockLength = Objects.requireNonNull(Protocols.readInt(buffer));
            context.setMessage(new Request(pieceIndex, blockOffset, blockLength));
            consumed = length;
        }
        return consumed;
    }
}

