/*
 * Decompiled with CFR 0.152.
 */
package bt.runtime;

import bt.BtException;
import bt.module.BtModuleProvider;
import bt.module.ProtocolModule;
import bt.module.ServiceModule;
import bt.peer.lan.LocalServiceDiscoveryModule;
import bt.peerexchange.PeerExchangeModule;
import bt.runtime.BtRuntime;
import bt.runtime.Config;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BtRuntimeBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(BtRuntimeBuilder.class);
    private Config config;
    private Collection<BtModuleProvider> customProviders;
    private boolean shouldDisableAutomaticShutdown;
    private boolean shouldAutoLoadModules;
    private boolean shouldDisableStandardExtensions;

    public BtRuntimeBuilder() {
        this.config = new Config();
    }

    public BtRuntimeBuilder(Config config) {
        this.config = Objects.requireNonNull(config, "Missing runtime config");
    }

    public BtRuntimeBuilder config(Config config) {
        this.config = Objects.requireNonNull(config, "Missing runtime config");
        return this;
    }

    public Config getConfig() {
        return this.config;
    }

    public BtRuntimeBuilder module(Module adapter) {
        Objects.requireNonNull(adapter);
        if (this.customProviders == null) {
            this.customProviders = new ArrayList<BtModuleProvider>();
        }
        this.customProviders.add(() -> adapter);
        return this;
    }

    public BtRuntimeBuilder module(Class<? extends Module> adapterType) {
        Objects.requireNonNull(adapterType);
        if (this.customProviders == null) {
            this.customProviders = new ArrayList<BtModuleProvider>();
        }
        this.customProviders.add(() -> {
            try {
                return (Module)adapterType.newInstance();
            }
            catch (Exception e) {
                throw new BtException("Failed to instantiate custom module: " + adapterType.getName(), e);
            }
        });
        return this;
    }

    public BtRuntimeBuilder disableAutomaticShutdown() {
        this.shouldDisableAutomaticShutdown = true;
        return this;
    }

    public BtRuntimeBuilder autoLoadModules() {
        this.shouldAutoLoadModules = true;
        return this;
    }

    public BtRuntimeBuilder disableStandardExtensions() {
        this.shouldDisableStandardExtensions = true;
        return this;
    }

    public BtRuntime build() {
        Injector injector = this.createInjector();
        Config config = (Config)Objects.requireNonNull(injector.getInstance(Config.class), "Missing config binding");
        BtRuntime runtime = new BtRuntime(injector, config);
        if (this.shouldDisableAutomaticShutdown) {
            runtime.disableAutomaticShutdown();
        }
        return runtime;
    }

    private Injector createInjector() {
        Map<Class<? extends Module>, Module> standardModules = this.mapByClass(this.collectModules(this.standardProviders()));
        Map<Object, Object> standardExtensions = this.shouldDisableStandardExtensions ? new HashMap() : this.mapByClass(this.collectModules(this.standardExtensionProviders()));
        Map<Object, Object> autoLoadedModules = this.shouldAutoLoadModules ? this.mapByClass(this.collectModules(this.autoLoadedProviders())) : new HashMap();
        Map<Class<? extends Module>, Module> customModules = this.mapByClass(this.collectModules(this.customProviders()));
        standardExtensions.forEach((k, v) -> {
            if (!autoLoadedModules.containsKey(k) && !customModules.containsKey(k)) {
                LOGGER.info("Loading standard extension module {}", (Object)k.getName());
            }
        });
        customModules.forEach((k, v) -> {
            boolean overridesStandardModule = standardModules.containsKey(k);
            boolean overridesStandardExtension = standardExtensions.containsKey(k);
            if (autoLoadedModules.containsKey(k)) {
                LOGGER.info("Overriding auto-loaded module {}", (Object)k.getName());
            } else if (overridesStandardModule || overridesStandardExtension) {
                LOGGER.info("Overriding standard " + (overridesStandardModule ? "module" : "extension") + " {}", (Object)k.getName());
            } else {
                LOGGER.info("Loading module {}", (Object)k.getName());
            }
        });
        autoLoadedModules.forEach((k, v) -> {
            boolean overridesStandardModule = standardModules.containsKey(k);
            boolean overridesStandardExtension = standardExtensions.containsKey(k);
            boolean overridenByCustomModule = customModules.containsKey(k);
            if (!overridenByCustomModule) {
                if (overridesStandardModule || overridesStandardExtension) {
                    LOGGER.info("Overriding standard " + (overridesStandardModule ? "module" : "extension") + " {} with auto-loaded version", (Object)k.getName());
                } else {
                    LOGGER.info("Auto-loading module {} with default configuration", (Object)k.getName());
                }
            }
        });
        return this.createInjector(standardModules, standardExtensions, autoLoadedModules, customModules);
    }

    private Injector createInjector(Map<Class<? extends Module>, Module> standardModules, Map<Class<? extends Module>, Module> standardExtensions, Map<Class<? extends Module>, Module> autoLoadedModules, Map<Class<? extends Module>, Module> customModules) {
        Module combinedModule = ((Stream)Arrays.asList(standardModules, standardExtensions, autoLoadedModules, customModules).stream().sequential()).filter(map -> !map.isEmpty()).map(map -> Modules.combine(map.values())).reduce(null, (m1, m2) -> m1 == null ? m2 : Modules.override((Module[])new Module[]{m1}).with(new Module[]{m2}));
        return Guice.createInjector((Module[])new Module[]{combinedModule});
    }

    private Collection<Module> collectModules(Collection<BtModuleProvider> ... providers) {
        return Arrays.asList(providers).stream().flatMap(Collection::stream).map(BtModuleProvider::module).collect(Collectors.toList());
    }

    private <T> Map<Class<? extends T>, T> mapByClass(Collection<T> collection) {
        return collection.stream().collect(HashMap::new, (m, o) -> {
            Class<?> moduleType = o.getClass();
            if (m.containsKey(moduleType)) {
                throw new IllegalStateException("Duplicate module: " + moduleType.getName());
            }
            m.put(moduleType, o);
        }, Map::putAll);
    }

    private Collection<BtModuleProvider> standardProviders() {
        ArrayList<BtModuleProvider> standardProviders = new ArrayList<BtModuleProvider>();
        standardProviders.add(() -> new ServiceModule(this.config));
        standardProviders.add(ProtocolModule::new);
        return standardProviders;
    }

    private Collection<BtModuleProvider> standardExtensionProviders() {
        ArrayList<BtModuleProvider> standardExtensionProviders = new ArrayList<BtModuleProvider>();
        standardExtensionProviders.add(PeerExchangeModule::new);
        standardExtensionProviders.add(LocalServiceDiscoveryModule::new);
        return standardExtensionProviders;
    }

    private Collection<BtModuleProvider> customProviders() {
        if (this.customProviders == null) {
            return Collections.emptyList();
        }
        return this.customProviders.stream().map(BtRuntimeBuilder::nullCheckingProvider).collect(Collectors.toList());
    }

    private Collection<BtModuleProvider> autoLoadedProviders() {
        ArrayList<BtModuleProvider> autoLoadedProviders = new ArrayList<BtModuleProvider>();
        ServiceLoader.load(BtModuleProvider.class).forEach(p -> autoLoadedProviders.add(BtRuntimeBuilder.nullCheckingProvider(p)));
        return autoLoadedProviders;
    }

    private static BtModuleProvider nullCheckingProvider(BtModuleProvider provider) {
        return () -> Objects.requireNonNull(provider.module(), "Missing module in provider:" + provider.getClass().getName());
    }
}

