/*
 * Decompiled with CFR 0.152.
 */
package bt.runtime;

import bt.protocol.crypto.EncryptionPolicy;
import bt.service.NetworkUtil;
import java.net.InetAddress;
import java.time.Duration;

public class Config {
    private InetAddress acceptorAddress;
    private int acceptorPort;
    private Duration peerDiscoveryInterval;
    private Duration peerHandshakeTimeout;
    private Duration peerConnectionRetryInterval;
    private int peerConnectionRetryCount;
    private Duration peerConnectionTimeout;
    private Duration peerConnectionInactivityThreshold;
    private Duration trackerQueryInterval;
    private int maxPeerConnections;
    private int maxPeerConnectionsPerTorrent;
    private int transferBlockSize;
    private int maxTransferBlockSize;
    private int maxIOQueueSize;
    private Duration shutdownHookTimeout;
    private int numOfHashingThreads;
    private int maxConcurrentlyActivePeerConnectionsPerTorrent;
    private Duration maxPieceReceivingTime;
    private Duration maxMessageProcessingInterval;
    private Duration unreachablePeerBanDuration;
    private int maxPendingConnectionRequests;
    private Duration timeoutedAssignmentPeerBanDuration;
    private EncryptionPolicy encryptionPolicy;
    private int metadataExchangeBlockSize;
    private int metadataExchangeMaxSize;
    private int msePrivateKeySize;
    private int numberOfPeersToRequestFromTracker;

    public Config() {
        this.acceptorAddress = NetworkUtil.getInetAddressFromNetworkInterfaces();
        this.acceptorPort = 6891;
        this.peerDiscoveryInterval = Duration.ofSeconds(5L);
        this.peerConnectionRetryInterval = Duration.ofMinutes(5L);
        this.peerConnectionRetryCount = 3;
        this.peerConnectionTimeout = Duration.ofSeconds(30L);
        this.peerHandshakeTimeout = Duration.ofSeconds(30L);
        this.peerConnectionInactivityThreshold = Duration.ofMinutes(3L);
        this.trackerQueryInterval = Duration.ofMinutes(5L);
        this.maxPeerConnectionsPerTorrent = this.maxPeerConnections = 500;
        this.transferBlockSize = 8192;
        this.maxTransferBlockSize = 131072;
        this.maxIOQueueSize = 1000;
        this.shutdownHookTimeout = Duration.ofSeconds(30L);
        this.numOfHashingThreads = 1;
        this.maxConcurrentlyActivePeerConnectionsPerTorrent = 20;
        this.maxPieceReceivingTime = Duration.ofSeconds(30L);
        this.maxMessageProcessingInterval = Duration.ofMillis(100L);
        this.unreachablePeerBanDuration = Duration.ofMinutes(30L);
        this.maxPendingConnectionRequests = 50;
        this.timeoutedAssignmentPeerBanDuration = Duration.ofMinutes(1L);
        this.encryptionPolicy = EncryptionPolicy.PREFER_PLAINTEXT;
        this.metadataExchangeBlockSize = 16384;
        this.metadataExchangeMaxSize = 0x200000;
        this.msePrivateKeySize = 20;
        this.numberOfPeersToRequestFromTracker = 50;
    }

    public Config(Config config) {
        this.acceptorAddress = config.getAcceptorAddress();
        this.acceptorPort = config.getAcceptorPort();
        this.peerDiscoveryInterval = config.getPeerDiscoveryInterval();
        this.peerConnectionRetryInterval = config.getPeerConnectionRetryInterval();
        this.peerConnectionRetryCount = config.getPeerConnectionRetryCount();
        this.peerConnectionTimeout = config.getPeerConnectionTimeout();
        this.peerHandshakeTimeout = config.getPeerHandshakeTimeout();
        this.peerConnectionInactivityThreshold = config.getPeerConnectionInactivityThreshold();
        this.trackerQueryInterval = config.getTrackerQueryInterval();
        this.maxPeerConnections = config.getMaxPeerConnections();
        this.maxPeerConnectionsPerTorrent = config.getMaxPeerConnectionsPerTorrent();
        this.transferBlockSize = config.getTransferBlockSize();
        this.maxTransferBlockSize = config.getMaxTransferBlockSize();
        this.maxIOQueueSize = config.getMaxIOQueueSize();
        this.shutdownHookTimeout = config.getShutdownHookTimeout();
        this.numOfHashingThreads = config.getNumOfHashingThreads();
        this.maxConcurrentlyActivePeerConnectionsPerTorrent = config.getMaxConcurrentlyActivePeerConnectionsPerTorrent();
        this.maxPieceReceivingTime = config.getMaxPieceReceivingTime();
        this.maxMessageProcessingInterval = config.getMaxMessageProcessingInterval();
        this.unreachablePeerBanDuration = config.getUnreachablePeerBanDuration();
        this.maxPendingConnectionRequests = config.getMaxPendingConnectionRequests();
        this.timeoutedAssignmentPeerBanDuration = config.getTimeoutedAssignmentPeerBanDuration();
        this.encryptionPolicy = config.getEncryptionPolicy();
        this.metadataExchangeBlockSize = config.getMetadataExchangeBlockSize();
        this.metadataExchangeMaxSize = config.getMetadataExchangeMaxSize();
        this.msePrivateKeySize = config.getMsePrivateKeySize();
        this.numberOfPeersToRequestFromTracker = config.getNumberOfPeersToRequestFromTracker();
    }

    public void setAcceptorAddress(InetAddress acceptorAddress) {
        this.acceptorAddress = acceptorAddress;
    }

    public InetAddress getAcceptorAddress() {
        return this.acceptorAddress;
    }

    public void setAcceptorPort(int acceptorPort) {
        this.acceptorPort = acceptorPort;
    }

    public int getAcceptorPort() {
        return this.acceptorPort;
    }

    public void setPeerDiscoveryInterval(Duration peerDiscoveryInterval) {
        this.peerDiscoveryInterval = peerDiscoveryInterval;
    }

    public Duration getPeerDiscoveryInterval() {
        return this.peerDiscoveryInterval;
    }

    public void setPeerHandshakeTimeout(Duration peerHandshakeTimeout) {
        this.peerHandshakeTimeout = peerHandshakeTimeout;
    }

    public Duration getPeerHandshakeTimeout() {
        return this.peerHandshakeTimeout;
    }

    public void setPeerConnectionRetryInterval(Duration peerConnectionRetryInterval) {
        this.peerConnectionRetryInterval = peerConnectionRetryInterval;
    }

    public Duration getPeerConnectionRetryInterval() {
        return this.peerConnectionRetryInterval;
    }

    public void setPeerConnectionRetryCount(int peerConnectionRetryCount) {
        this.peerConnectionRetryCount = peerConnectionRetryCount;
    }

    public int getPeerConnectionRetryCount() {
        return this.peerConnectionRetryCount;
    }

    public void setPeerConnectionTimeout(Duration peerConnectionTimeout) {
        this.peerConnectionTimeout = peerConnectionTimeout;
    }

    public Duration getPeerConnectionTimeout() {
        return this.peerConnectionTimeout;
    }

    public void setPeerConnectionInactivityThreshold(Duration peerConnectionInactivityThreshold) {
        this.peerConnectionInactivityThreshold = peerConnectionInactivityThreshold;
    }

    public Duration getPeerConnectionInactivityThreshold() {
        return this.peerConnectionInactivityThreshold;
    }

    public void setTrackerQueryInterval(Duration trackerQueryInterval) {
        this.trackerQueryInterval = trackerQueryInterval;
    }

    public Duration getTrackerQueryInterval() {
        return this.trackerQueryInterval;
    }

    public void setMaxPeerConnections(int maxPeerConnections) {
        this.maxPeerConnections = maxPeerConnections;
    }

    public int getMaxPeerConnections() {
        return this.maxPeerConnections;
    }

    public void setMaxPeerConnectionsPerTorrent(int maxPeerConnectionsPerTorrent) {
        this.maxPeerConnectionsPerTorrent = maxPeerConnectionsPerTorrent;
    }

    public int getMaxPeerConnectionsPerTorrent() {
        return this.maxPeerConnectionsPerTorrent;
    }

    public void setTransferBlockSize(int transferBlockSize) {
        this.transferBlockSize = transferBlockSize;
    }

    public int getTransferBlockSize() {
        return this.transferBlockSize;
    }

    public void setMaxTransferBlockSize(int maxTransferBlockSize) {
        this.maxTransferBlockSize = maxTransferBlockSize;
    }

    public int getMaxTransferBlockSize() {
        return this.maxTransferBlockSize;
    }

    public void setMaxIOQueueSize(int maxIOQueueSize) {
        this.maxIOQueueSize = maxIOQueueSize;
    }

    public int getMaxIOQueueSize() {
        return this.maxIOQueueSize;
    }

    public void setShutdownHookTimeout(Duration shutdownHookTimeout) {
        this.shutdownHookTimeout = shutdownHookTimeout;
    }

    public Duration getShutdownHookTimeout() {
        return this.shutdownHookTimeout;
    }

    public void setNumOfHashingThreads(int numOfHashingThreads) {
        this.numOfHashingThreads = numOfHashingThreads;
    }

    public int getNumOfHashingThreads() {
        return this.numOfHashingThreads;
    }

    public void setMaxConcurrentlyActivePeerConnectionsPerTorrent(int maxConcurrentlyActivePeerConnectionsPerTorrent) {
        this.maxConcurrentlyActivePeerConnectionsPerTorrent = maxConcurrentlyActivePeerConnectionsPerTorrent;
    }

    public int getMaxConcurrentlyActivePeerConnectionsPerTorrent() {
        return this.maxConcurrentlyActivePeerConnectionsPerTorrent;
    }

    public void setMaxPieceReceivingTime(Duration maxPieceReceivingTime) {
        this.maxPieceReceivingTime = maxPieceReceivingTime;
    }

    public Duration getMaxPieceReceivingTime() {
        return this.maxPieceReceivingTime;
    }

    public void setMaxMessageProcessingInterval(Duration maxMessageProcessingInterval) {
        this.maxMessageProcessingInterval = maxMessageProcessingInterval;
    }

    public Duration getMaxMessageProcessingInterval() {
        return this.maxMessageProcessingInterval;
    }

    public void setUnreachablePeerBanDuration(Duration unreachablePeerBanDuration) {
        this.unreachablePeerBanDuration = unreachablePeerBanDuration;
    }

    public Duration getUnreachablePeerBanDuration() {
        return this.unreachablePeerBanDuration;
    }

    public void setMaxPendingConnectionRequests(int maxPendingConnectionRequests) {
        this.maxPendingConnectionRequests = maxPendingConnectionRequests;
    }

    public int getMaxPendingConnectionRequests() {
        return this.maxPendingConnectionRequests;
    }

    public void setTimeoutedAssignmentPeerBanDuration(Duration timeoutedAssignmentPeerBanDuration) {
        this.timeoutedAssignmentPeerBanDuration = timeoutedAssignmentPeerBanDuration;
    }

    public Duration getTimeoutedAssignmentPeerBanDuration() {
        return this.timeoutedAssignmentPeerBanDuration;
    }

    public void setEncryptionPolicy(EncryptionPolicy encryptionPolicy) {
        this.encryptionPolicy = encryptionPolicy;
    }

    public EncryptionPolicy getEncryptionPolicy() {
        return this.encryptionPolicy;
    }

    public void setMetadataExchangeBlockSize(int metadataExchangeBlockSize) {
        this.metadataExchangeBlockSize = metadataExchangeBlockSize;
    }

    public int getMetadataExchangeBlockSize() {
        return this.metadataExchangeBlockSize;
    }

    public void setMetadataExchangeMaxSize(int metadataExchangeMaxSize) {
        this.metadataExchangeMaxSize = metadataExchangeMaxSize;
    }

    public int getMetadataExchangeMaxSize() {
        return this.metadataExchangeMaxSize;
    }

    public void setMsePrivateKeySize(int msePrivateKeySize) {
        this.msePrivateKeySize = msePrivateKeySize;
    }

    public int getMsePrivateKeySize() {
        return this.msePrivateKeySize;
    }

    public void setNumberOfPeersToRequestFromTracker(int numberOfPeersToRequestFromTracker) {
        this.numberOfPeersToRequestFromTracker = numberOfPeersToRequestFromTracker;
    }

    public int getNumberOfPeersToRequestFromTracker() {
        return this.numberOfPeersToRequestFromTracker;
    }
}

