/*
 * Decompiled with CFR 0.152.
 */
package bt.service;

import bt.BtException;
import bt.service.ApplicationService;
import bt.service.Version;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathApplicationService
implements ApplicationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathApplicationService.class);
    private static final String MANIFEST_FILE = "META-INF/MANIFEST.MF";
    private static final String BUNDLE_NAME_PREFIX = "com.github.atomashpolskiy.bt";
    private static final String BUNDLE_NAME_KEY = "Bundle-SymbolicName";
    private final Version version;

    public ClasspathApplicationService() {
        Enumeration<URL> urls;
        try {
            urls = ClasspathApplicationService.class.getClassLoader().getResources(MANIFEST_FILE);
        }
        catch (IOException e) {
            throw new BtException("Failed to read application version", e);
        }
        Manifest manifest = null;
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Processing manifest file: " + url.toExternalForm());
            }
            try {
                InputStream in = url.openStream();
                Throwable throwable = null;
                try {
                    Manifest m = new Manifest(in);
                    String bundleName = m.getMainAttributes().getValue(BUNDLE_NAME_KEY);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Bundle-SymbolicName: " + bundleName);
                    }
                    if (bundleName == null || !bundleName.startsWith(BUNDLE_NAME_PREFIX)) continue;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Will read version from manifest file: {}", (Object)url.toExternalForm());
                    }
                    manifest = m;
                    break;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Throwable e) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Failed to read manifest file: " + url.toExternalForm(), e);
            }
        }
        if (manifest == null) {
            LOGGER.warn("Failed to determine version from manifest file -- application may be configured incorrectly");
            this.version = new Version(0, 0, false);
        } else {
            this.version = this.parseVersion(manifest.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Bt version {}", (Object)this.version);
            }
        }
    }

    private Version parseVersion(String versionStr) {
        int minor;
        int major;
        Pattern pattern = Pattern.compile("^(\\d+)[.](\\d+).*");
        Matcher matcher = pattern.matcher(versionStr);
        if (!matcher.matches()) {
            throw new BtException("Invalid version: " + versionStr);
        }
        try {
            major = Integer.valueOf(matcher.group(1));
            minor = Integer.valueOf(matcher.group(2));
        }
        catch (NumberFormatException e) {
            throw new BtException("Invalid version: " + versionStr);
        }
        boolean snapshot = versionStr.endsWith("-SNAPSHOT");
        return new Version(major, minor, snapshot);
    }

    @Override
    public Version getVersion() {
        return this.version;
    }
}

