/*
 * Decompiled with CFR 0.152.
 */
package bt.service;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorServiceProvider
implements Provider<ExecutorService> {
    private volatile ExecutorService executorService;
    private final Object lock = new Object();

    @Inject
    public ExecutorServiceProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService get() {
        if (this.executorService == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.executorService == null) {
                    this.executorService = Executors.newCachedThreadPool(new ThreadFactory(){
                        private AtomicInteger threadId = new AtomicInteger(1);

                        @Override
                        public Thread newThread(Runnable r) {
                            return new Thread(r, Objects.requireNonNull(ExecutorServiceProvider.this.getNamePrefix()) + "-" + this.threadId.getAndIncrement());
                        }
                    });
                }
            }
        }
        return this.executorService;
    }

    protected String getNamePrefix() {
        return "bt.service.executor-thread";
    }
}

