/*
 * Decompiled with CFR 0.152.
 */
package bt.service;

import java.util.Objects;
import java.util.Optional;

public class LifecycleBinding {
    private Optional<String> description;
    private Runnable r;
    private boolean async;

    public static Builder bind(Runnable r) {
        return new Builder(r);
    }

    private LifecycleBinding(String description, Runnable r, boolean async) {
        this.description = Optional.ofNullable(description);
        this.r = r;
        this.async = async;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public Runnable getRunnable() {
        return this.r;
    }

    public boolean isAsync() {
        return this.async;
    }

    public static class Builder {
        private Runnable r;
        private String description;
        private boolean async;

        private Builder(Runnable r) {
            this.r = Objects.requireNonNull(r);
        }

        public Builder description(String description) {
            this.description = Objects.requireNonNull(description);
            return this;
        }

        public Builder async() {
            this.async = true;
            return this;
        }

        public LifecycleBinding build() {
            return new LifecycleBinding(this.description, this.r, this.async);
        }
    }
}

