/*
 * Decompiled with CFR 0.152.
 */
package bt.torrent;

import bt.data.IDataDescriptorFactory;
import bt.data.Storage;
import bt.event.EventSink;
import bt.metainfo.Torrent;
import bt.metainfo.TorrentId;
import bt.service.IRuntimeLifecycleBinder;
import bt.torrent.DefaultTorrentDescriptor;
import bt.torrent.TorrentDescriptor;
import bt.torrent.TorrentRegistry;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AdhocTorrentRegistry
implements TorrentRegistry {
    private IDataDescriptorFactory dataDescriptorFactory;
    private IRuntimeLifecycleBinder lifecycleBinder;
    private EventSink eventSink;
    private Set<TorrentId> torrentIds;
    private ConcurrentMap<TorrentId, Torrent> torrents;
    private ConcurrentMap<TorrentId, DefaultTorrentDescriptor> descriptors;

    @Inject
    public AdhocTorrentRegistry(IDataDescriptorFactory dataDescriptorFactory, IRuntimeLifecycleBinder lifecycleBinder, EventSink eventSink) {
        this.dataDescriptorFactory = dataDescriptorFactory;
        this.lifecycleBinder = lifecycleBinder;
        this.eventSink = eventSink;
        this.torrentIds = ConcurrentHashMap.newKeySet();
        this.torrents = new ConcurrentHashMap<TorrentId, Torrent>();
        this.descriptors = new ConcurrentHashMap<TorrentId, DefaultTorrentDescriptor>();
    }

    @Override
    public Collection<Torrent> getTorrents() {
        return Collections.unmodifiableCollection(this.torrents.values());
    }

    @Override
    public Collection<TorrentId> getTorrentIds() {
        return Collections.unmodifiableCollection(this.torrentIds);
    }

    @Override
    public Optional<Torrent> getTorrent(TorrentId torrentId) {
        Objects.requireNonNull(torrentId, "Missing torrent ID");
        return Optional.ofNullable(this.torrents.get(torrentId));
    }

    @Override
    public Optional<TorrentDescriptor> getDescriptor(Torrent torrent) {
        return Optional.ofNullable(this.descriptors.get(torrent.getTorrentId()));
    }

    @Override
    public Optional<TorrentDescriptor> getDescriptor(TorrentId torrentId) {
        Objects.requireNonNull(torrentId, "Missing torrent ID");
        return Optional.ofNullable(this.descriptors.get(torrentId));
    }

    @Override
    public TorrentDescriptor getOrCreateDescriptor(Torrent torrent, Storage storage) {
        return this.register(torrent, storage);
    }

    @Override
    public TorrentDescriptor register(Torrent torrent, Storage storage) {
        TorrentId torrentId = torrent.getTorrentId();
        DefaultTorrentDescriptor descriptor = (DefaultTorrentDescriptor)this.descriptors.get(torrentId);
        if (descriptor != null) {
            if (descriptor.getDataDescriptor() != null) {
                throw new IllegalStateException("Torrent already registered and data descriptor created: " + torrent.getTorrentId());
            }
            descriptor.setDataDescriptor(this.dataDescriptorFactory.createDescriptor(torrent, storage));
        } else {
            descriptor = new DefaultTorrentDescriptor(torrentId, this.eventSink);
            descriptor.setDataDescriptor(this.dataDescriptorFactory.createDescriptor(torrent, storage));
            DefaultTorrentDescriptor existing = this.descriptors.putIfAbsent(torrentId, descriptor);
            if (existing != null) {
                descriptor = existing;
            } else {
                this.torrentIds.add(torrentId);
                this.addShutdownHook(torrentId, descriptor);
            }
        }
        this.torrents.putIfAbsent(torrentId, torrent);
        return descriptor;
    }

    @Override
    public TorrentDescriptor register(TorrentId torrentId) {
        return this.getDescriptor(torrentId).orElseGet(() -> {
            DefaultTorrentDescriptor descriptor = new DefaultTorrentDescriptor(torrentId, this.eventSink);
            DefaultTorrentDescriptor existing = this.descriptors.putIfAbsent(torrentId, descriptor);
            if (existing != null) {
                descriptor = existing;
            } else {
                this.torrentIds.add(torrentId);
                this.addShutdownHook(torrentId, descriptor);
            }
            return descriptor;
        });
    }

    @Override
    public boolean isSupportedAndActive(TorrentId torrentId) {
        Optional<TorrentDescriptor> descriptor = this.getDescriptor(torrentId);
        return this.getTorrentIds().contains(torrentId) && (!descriptor.isPresent() || descriptor.get().isActive());
    }

    private void addShutdownHook(TorrentId torrentId, TorrentDescriptor descriptor) {
        this.lifecycleBinder.onShutdown("Closing data descriptor for torrent ID: " + torrentId, () -> {
            if (descriptor.getDataDescriptor() != null) {
                try {
                    descriptor.getDataDescriptor().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

