/*
 * Decompiled with CFR 0.152.
 */
package bt.torrent;

import bt.data.Bitfield;
import bt.net.Peer;
import bt.torrent.PieceStatistics;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class BitfieldBasedStatistics
implements PieceStatistics {
    private final Bitfield localBitfield;
    private final Map<Peer, Bitfield> peerBitfields;
    private final int[] pieceTotals;

    public BitfieldBasedStatistics(Bitfield localBitfield) {
        this.localBitfield = localBitfield;
        this.peerBitfields = new ConcurrentHashMap<Peer, Bitfield>();
        this.pieceTotals = new int[localBitfield.getPiecesTotal()];
    }

    public void addBitfield(Peer peer, Bitfield bitfield) {
        this.validateBitfieldLength(bitfield);
        this.peerBitfields.put(peer, bitfield);
        for (int i = 0; i < this.pieceTotals.length; ++i) {
            if (bitfield.getPieceStatus(i) != Bitfield.PieceStatus.COMPLETE_VERIFIED) continue;
            this.incrementPieceTotal(i);
        }
    }

    private synchronized void incrementPieceTotal(int i) {
        int n = i;
        this.pieceTotals[n] = this.pieceTotals[n] + 1;
    }

    public void removeBitfield(Peer peer) {
        Bitfield bitfield = this.peerBitfields.remove(peer);
        if (bitfield == null) {
            return;
        }
        for (int i = 0; i < this.pieceTotals.length; ++i) {
            if (bitfield.getPieceStatus(i) != Bitfield.PieceStatus.COMPLETE_VERIFIED) continue;
            this.decrementPieceTotal(i);
        }
    }

    private synchronized void decrementPieceTotal(int i) {
        int n = i;
        this.pieceTotals[n] = this.pieceTotals[n] - 1;
    }

    private void validateBitfieldLength(Bitfield bitfield) {
        if (bitfield.getPiecesTotal() != this.pieceTotals.length) {
            throw new IllegalArgumentException("Bitfield has invalid length (" + bitfield.getPiecesTotal() + "). Expected number of pieces: " + this.pieceTotals.length);
        }
    }

    public void addPiece(Peer peer, Integer pieceIndex) {
        Bitfield existing;
        Bitfield bitfield = this.peerBitfields.get(peer);
        if (bitfield == null && (existing = this.peerBitfields.putIfAbsent(peer, bitfield = new Bitfield(this.localBitfield.getPiecesTotal()))) != null) {
            bitfield = existing;
        }
        this.markPieceVerified(bitfield, pieceIndex);
    }

    private synchronized void markPieceVerified(Bitfield bitfield, Integer pieceIndex) {
        if (!bitfield.isVerified(pieceIndex)) {
            bitfield.markVerified(pieceIndex);
            this.incrementPieceTotal(pieceIndex);
        }
    }

    public Optional<Bitfield> getPeerBitfield(Peer peer) {
        return Optional.ofNullable(this.peerBitfields.get(peer));
    }

    @Override
    public synchronized int getCount(int pieceIndex) {
        return this.pieceTotals[pieceIndex];
    }

    @Override
    public int getPiecesTotal() {
        return this.pieceTotals.length;
    }
}

