/*
 * Decompiled with CFR 0.152.
 */
package bt.torrent;

import bt.data.DataDescriptor;
import bt.event.EventSink;
import bt.metainfo.TorrentId;
import bt.torrent.TorrentDescriptor;

class DefaultTorrentDescriptor
implements TorrentDescriptor {
    private final TorrentId torrentId;
    private final EventSink eventSink;
    private volatile DataDescriptor dataDescriptor;
    private volatile boolean active;

    DefaultTorrentDescriptor(TorrentId torrentId, EventSink eventSink) {
        this.torrentId = torrentId;
        this.eventSink = eventSink;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public synchronized void start() {
        this.active = true;
        this.eventSink.fireTorrentStarted(this.torrentId);
    }

    @Override
    public synchronized void stop() {
        this.active = false;
        this.eventSink.fireTorrentStopped(this.torrentId);
    }

    @Override
    public void complete() {
    }

    @Override
    public DataDescriptor getDataDescriptor() {
        return this.dataDescriptor;
    }

    void setDataDescriptor(DataDescriptor dataDescriptor) {
        this.dataDescriptor = dataDescriptor;
    }
}

