/*
 * Decompiled with CFR 0.152.
 */
package bt.torrent;

import bt.net.Peer;
import bt.torrent.TorrentDescriptor;
import bt.torrent.TorrentSessionState;
import bt.torrent.messaging.ConnectionState;
import bt.torrent.messaging.TorrentWorker;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class DefaultTorrentSessionState
implements TorrentSessionState {
    private static final int DOWNLOADED_POSITION = 0;
    private static final int UPLOADED_POSITION = 1;
    private Map<Peer, Long[]> recentAmountsForConnectedPeers = new HashMap<Peer, Long[]>();
    private volatile AtomicLong downloadedFromDisconnected = new AtomicLong();
    private volatile AtomicLong uploadedToDisconnected = new AtomicLong();
    private final TorrentDescriptor descriptor;
    private final TorrentWorker worker;

    public DefaultTorrentSessionState(TorrentDescriptor descriptor, TorrentWorker worker) {
        this.descriptor = descriptor;
        this.worker = worker;
    }

    @Override
    public int getPiecesTotal() {
        if (this.descriptor.getDataDescriptor() != null) {
            return this.descriptor.getDataDescriptor().getBitfield().getPiecesTotal();
        }
        return 1;
    }

    @Override
    public int getPiecesRemaining() {
        if (this.descriptor.getDataDescriptor() != null) {
            return this.descriptor.getDataDescriptor().getBitfield().getPiecesRemaining();
        }
        return 1;
    }

    @Override
    public synchronized long getDownloaded() {
        long downloaded = this.getCurrentAmounts().values().stream().collect(Collectors.summingLong(amounts -> amounts[0]));
        return downloaded += this.downloadedFromDisconnected.get();
    }

    @Override
    public synchronized long getUploaded() {
        long uploaded = this.getCurrentAmounts().values().stream().collect(Collectors.summingLong(amounts -> amounts[1]));
        return uploaded += this.uploadedToDisconnected.get();
    }

    private synchronized Map<Peer, Long[]> getCurrentAmounts() {
        Map<Peer, Long[]> connectedPeers = this.getAmountsForConnectedPeers();
        connectedPeers.forEach((peer, amounts) -> this.recentAmountsForConnectedPeers.put((Peer)peer, (Long[])amounts));
        HashSet disconnectedPeers = new HashSet();
        this.recentAmountsForConnectedPeers.forEach((peer, amounts) -> {
            if (!connectedPeers.containsKey(peer)) {
                this.downloadedFromDisconnected.addAndGet(amounts[0]);
                this.uploadedToDisconnected.addAndGet(amounts[1]);
                disconnectedPeers.add(peer);
            }
        });
        disconnectedPeers.forEach(this.recentAmountsForConnectedPeers::remove);
        return this.recentAmountsForConnectedPeers;
    }

    private Map<Peer, Long[]> getAmountsForConnectedPeers() {
        return this.worker.getPeers().stream().collect(HashMap::new, (acc, peer) -> {
            ConnectionState connectionState = this.worker.getConnectionState((Peer)peer);
            acc.put(peer, new Long[]{connectionState.getDownloaded(), connectionState.getUploaded()});
        }, HashMap::putAll);
    }

    @Override
    public Set<Peer> getConnectedPeers() {
        return Collections.unmodifiableSet(this.worker.getPeers());
    }
}

