/*
 * Decompiled with CFR 0.152.
 */
package bt.torrent;

import bt.metainfo.Torrent;
import bt.torrent.TorrentSessionState;
import bt.tracker.AnnounceKey;
import bt.tracker.ITrackerService;
import bt.tracker.Tracker;
import bt.tracker.TrackerRequestBuilder;
import bt.tracker.TrackerResponse;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackerAnnouncer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrackerAnnouncer.class);
    private final Optional<Tracker> trackerOptional;
    private final Torrent torrent;
    private final TorrentSessionState sessionState;

    public TrackerAnnouncer(ITrackerService trackerService, Torrent torrent, AnnounceKey announceKey, TorrentSessionState sessionState) {
        this.trackerOptional = Optional.ofNullable(this.createTracker(trackerService, announceKey));
        this.torrent = torrent;
        this.sessionState = sessionState;
    }

    private Tracker createTracker(ITrackerService trackerService, AnnounceKey announceKey) {
        try {
            String trackerUrl = this.getTrackerUrl(announceKey);
            if (trackerService.isSupportedProtocol(trackerUrl)) {
                return trackerService.getTracker(announceKey);
            }
            LOGGER.warn("Tracker URL protocol is not supported: " + trackerUrl);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create tracker for announce key: " + announceKey);
        }
        return null;
    }

    private String getTrackerUrl(AnnounceKey announceKey) {
        if (announceKey.isMultiKey()) {
            return announceKey.getTrackerUrls().get(0).get(0);
        }
        return announceKey.getTrackerUrl();
    }

    public void start() {
        this.trackerOptional.ifPresent(tracker -> {
            try {
                this.processResponse(Event.start, (Tracker)tracker, this.prepareAnnounce((Tracker)tracker).start());
            }
            catch (Exception e) {
                this.logTrackerError(Event.start, (Tracker)tracker, Optional.of(e), Optional.empty());
            }
        });
    }

    public void stop() {
        this.trackerOptional.ifPresent(tracker -> {
            try {
                this.processResponse(Event.stop, (Tracker)tracker, this.prepareAnnounce((Tracker)tracker).stop());
            }
            catch (Exception e) {
                this.logTrackerError(Event.stop, (Tracker)tracker, Optional.of(e), Optional.empty());
            }
        });
    }

    public void complete() {
        this.trackerOptional.ifPresent(tracker -> {
            try {
                this.processResponse(Event.complete, (Tracker)tracker, this.prepareAnnounce((Tracker)tracker).complete());
            }
            catch (Exception e) {
                this.logTrackerError(Event.complete, (Tracker)tracker, Optional.of(e), Optional.empty());
            }
        });
    }

    private TrackerRequestBuilder prepareAnnounce(Tracker tracker) {
        return tracker.request(this.torrent.getTorrentId()).downloaded(this.sessionState.getDownloaded()).uploaded(this.sessionState.getUploaded()).left((long)this.sessionState.getPiecesRemaining() * this.torrent.getChunkSize());
    }

    private void processResponse(Event event, Tracker tracker, TrackerResponse response) {
        if (!response.isSuccess()) {
            this.logTrackerError(event, tracker, response.getError(), Optional.ofNullable(response.getErrorMessage()));
        }
    }

    private void logTrackerError(Event event, Tracker tracker, Optional<Throwable> e, Optional<String> message) {
        String log = String.format("Failed to announce '%s' event due to unexpected error during interaction with the tracker: %s", event.name(), tracker);
        if (message.isPresent()) {
            log = log + "; message: " + message;
        }
        if (e.isPresent()) {
            LOGGER.error(log, e.get());
        } else {
            LOGGER.warn(log);
        }
    }

    private static enum Event {
        start,
        stop,
        complete;

    }
}

