/*
 * Decompiled with CFR 0.152.
 */
package bt.torrent.compiler;

import bt.protocol.Message;
import bt.torrent.annotation.Consumes;
import bt.torrent.annotation.Produces;
import bt.torrent.compiler.CompilerVisitor;
import bt.torrent.compiler.ConsumerInfo;
import bt.torrent.compiler.ProducerInfo;
import bt.torrent.messaging.MessageContext;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagingAgentCompiler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessagingAgentCompiler.class);
    private static final String CONSUMERS_KEY = "consumers";
    private static final String PRODUCERS_KEY = "producers";
    private Map<Class<?>, Map<String, Collection<?>>> compiledTypes = new HashMap();

    public void compileAndVisit(Object object, CompilerVisitor visitor) {
        Class<?> objectType = object.getClass();
        Map<String, Collection<?>> compiledType = this.compiledTypes.get(objectType);
        if (compiledType == null) {
            compiledType = this.compileType(objectType);
            this.compiledTypes.put(objectType, compiledType);
        }
        compiledType.get(CONSUMERS_KEY).forEach(o -> {
            ConsumerInfo consumerInfo = (ConsumerInfo)o;
            visitor.visitConsumer(consumerInfo.getConsumedMessageType(), consumerInfo.getHandle());
        });
        compiledType.get(PRODUCERS_KEY).forEach(o -> {
            ProducerInfo producerInfo = (ProducerInfo)o;
            visitor.visitProducer(producerInfo.getHandle());
        });
    }

    private Map<String, Collection<?>> compileType(Class<?> type) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Compiling messaging agent type: " + type.getName());
        }
        final ArrayList<ConsumerInfo> compiledConsumers = new ArrayList<ConsumerInfo>();
        final ArrayList<ProducerInfo> compiledProducers = new ArrayList<ProducerInfo>();
        HashMap compiledType = new HashMap<String, Collection<?>>(){
            {
                this.put(MessagingAgentCompiler.CONSUMERS_KEY, compiledConsumers);
                this.put(MessagingAgentCompiler.PRODUCERS_KEY, compiledProducers);
            }
        };
        int methodCount = this.compileType(type, compiledConsumers, compiledProducers);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Compiled " + methodCount + " consumer/producer methods");
        }
        return compiledType;
    }

    private int compileType(Class<?> type, Collection<ConsumerInfo> consumersAcc, Collection<ProducerInfo> producerAcc) {
        Class<?>[] interfaceTypes;
        int methodCount = 0;
        for (Method method : type.getDeclaredMethods()) {
            Consumes consumes = method.getAnnotation(Consumes.class);
            Produces produces = method.getAnnotation(Produces.class);
            if (consumes == null && produces == null) continue;
            if (!Modifier.isPublic(method.getModifiers())) {
                throw new IllegalStateException("Method representing consumer/producer must be public: " + method.getName());
            }
            if (consumes != null && produces != null) {
                throw new IllegalStateException("Method can not be both consumer and producer: " + method.getName());
            }
            if (consumes != null) {
                ConsumerInfo consumerInfo = MessagingAgentCompiler.buildConsumerInfo(method);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Compiled consumer method {consumedType=" + consumerInfo.getConsumedMessageType().getName() + "}: " + method.getName());
                }
                consumersAcc.add(consumerInfo);
            } else if (produces != null) {
                ProducerInfo producerInfo = this.buildProducerInfo(method);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Compiled producer method: " + method.getName());
                }
                producerAcc.add(producerInfo);
            }
            ++methodCount;
        }
        Class<?> supertype = type.getSuperclass();
        if (supertype != null && !Object.class.equals(supertype)) {
            methodCount += this.compileType(supertype, consumersAcc, producerAcc);
        }
        for (Class<?> interfaceType : interfaceTypes = type.getInterfaces()) {
            methodCount += this.compileType(interfaceType, consumersAcc, producerAcc);
        }
        return methodCount;
    }

    private static ConsumerInfo buildConsumerInfo(Method method) {
        MethodHandle handle;
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0 || parameterTypes.length > 2) {
            throw new IllegalStateException("Consumer method must have at least one and at most two parameters: " + Message.class.getName() + " or it's subclass (required), " + MessageContext.class.getName() + " (optional)");
        }
        if (!Message.class.isAssignableFrom(parameterTypes[0])) {
            throw new IllegalStateException("Consumer method must have " + Message.class.getName() + " or it's subclass as the first parameter");
        }
        if (parameterTypes.length == 2 && !MessageContext.class.equals(parameterTypes[1])) {
            throw new IllegalStateException("Consumer method must have " + MessageContext.class.getName() + " as the second parameter");
        }
        Class<?> consumedType = parameterTypes[0];
        ConsumerInfo consumerInfo = new ConsumerInfo();
        consumerInfo.setConsumedMessageType(consumedType);
        try {
            handle = MethodHandles.publicLookup().unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to create method handle: " + method.getName(), e);
        }
        consumerInfo.setHandle(handle);
        return consumerInfo;
    }

    private ProducerInfo buildProducerInfo(Method method) {
        MethodHandle handle;
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0 || parameterTypes.length > 2) {
            throw new IllegalStateException("Producer method must have at least one and at most two parameters: " + Consumer.class.getName() + "<" + Message.class.getName() + "> (required), " + MessageContext.class.getName() + " (optional)");
        }
        Optional<Type> argumentType = MessagingAgentCompiler.unwrapSingleTypeParameter(method.getGenericParameterTypes()[0]);
        if (!(Consumer.class.isAssignableFrom(parameterTypes[0]) && argumentType.isPresent() && Message.class.equals((Object)argumentType.get()))) {
            throw new IllegalStateException("Producer method must have " + Consumer.class.getName() + "<" + Message.class.getName() + "> as the first parameter");
        }
        if (parameterTypes.length == 2 && !MessageContext.class.equals(parameterTypes[1])) {
            throw new IllegalStateException("Producer method must have " + MessageContext.class.getName() + " as the second parameter");
        }
        try {
            handle = MethodHandles.publicLookup().unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to create method handle: " + method.getName(), e);
        }
        ProducerInfo producerInfo = new ProducerInfo();
        producerInfo.setHandle(handle);
        return producerInfo;
    }

    private static Optional<Type> unwrapSingleTypeParameter(Type type) {
        if (type instanceof ParameterizedType) {
            Type argumentType = ((ParameterizedType)type).getActualTypeArguments()[0];
            return Optional.of(argumentType);
        }
        return Optional.empty();
    }
}

