/*
 * Decompiled with CFR 0.152.
 */
package bt.torrent.data;

import bt.net.Peer;
import java.util.Optional;

public class BlockRead {
    private Peer peer;
    private int pieceIndex;
    private int offset;
    private Optional<byte[]> block;
    private boolean rejected;
    private Optional<Throwable> error;

    static BlockRead complete(Peer peer, int pieceIndex, int offset, byte[] block) {
        return new BlockRead(peer, null, false, pieceIndex, offset, block);
    }

    static BlockRead rejected(Peer peer, int pieceIndex, int offset) {
        return new BlockRead(peer, null, true, pieceIndex, offset, null);
    }

    static BlockRead exceptional(Peer peer, Throwable error, int pieceIndex, int offset) {
        return new BlockRead(peer, error, false, pieceIndex, offset, null);
    }

    private BlockRead(Peer peer, Throwable error, boolean rejected, int pieceIndex, int offset, byte[] block) {
        this.peer = peer;
        this.error = Optional.ofNullable(error);
        this.rejected = rejected;
        this.pieceIndex = pieceIndex;
        this.offset = offset;
        this.block = Optional.ofNullable(block);
    }

    public Peer getPeer() {
        return this.peer;
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public int getPieceIndex() {
        return this.pieceIndex;
    }

    public int getOffset() {
        return this.offset;
    }

    public Optional<byte[]> getBlock() {
        return this.block;
    }

    public Optional<Throwable> getError() {
        return this.error;
    }
}

