/*
 * Decompiled with CFR 0.152.
 */
package bt.torrent.data;

import bt.net.Peer;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class BlockWrite {
    private Peer peer;
    private int pieceIndex;
    private int offset;
    private byte[] block;
    private boolean rejected;
    private Optional<Throwable> error;
    private Optional<CompletableFuture<Boolean>> verificationFuture;

    static BlockWrite complete(Peer peer, int pieceIndex, int offset, byte[] block, CompletableFuture<Boolean> verificationFuture) {
        return new BlockWrite(peer, null, false, pieceIndex, offset, block, verificationFuture);
    }

    static BlockWrite rejected(Peer peer, int pieceIndex, int offset, byte[] block) {
        return new BlockWrite(peer, null, true, pieceIndex, offset, block, null);
    }

    static BlockWrite exceptional(Peer peer, Throwable error, int pieceIndex, int offset, byte[] block) {
        return new BlockWrite(peer, error, false, pieceIndex, offset, block, null);
    }

    private BlockWrite(Peer peer, Throwable error, boolean rejected, int pieceIndex, int offset, byte[] block, CompletableFuture<Boolean> verificationFuture) {
        this.peer = peer;
        this.error = Optional.ofNullable(error);
        this.rejected = rejected;
        this.pieceIndex = pieceIndex;
        this.offset = offset;
        this.block = block;
        this.verificationFuture = Optional.ofNullable(verificationFuture);
    }

    public Peer getPeer() {
        return this.peer;
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public int getPieceIndex() {
        return this.pieceIndex;
    }

    public int getOffset() {
        return this.offset;
    }

    public byte[] getBlock() {
        return this.block;
    }

    public Optional<Throwable> getError() {
        return this.error;
    }

    public Optional<CompletableFuture<Boolean>> getVerificationFuture() {
        return this.verificationFuture;
    }
}

