/*
 * Decompiled with CFR 0.152.
 */
package bt.torrent.messaging;

import bt.net.Peer;
import bt.torrent.messaging.ConnectionState;
import java.time.Duration;

class Assignment {
    private Peer peer;
    private Integer piece;
    private ConnectionState connectionState;
    private final Duration limit;
    private long started;
    private long checked;
    private boolean aborted;
    private boolean finished;

    Assignment(Peer peer, Integer piece, Duration limit) {
        this.peer = peer;
        this.piece = piece;
        this.limit = limit;
    }

    Peer getPeer() {
        return this.peer;
    }

    Integer getPiece() {
        return this.piece;
    }

    Status getStatus() {
        long duration;
        if (this.finished) {
            return Status.DONE;
        }
        if (this.started > 0L && (duration = System.currentTimeMillis() - this.started) > this.limit.toMillis()) {
            return Status.TIMEOUT;
        }
        return Status.ACTIVE;
    }

    void start(ConnectionState connectionState) {
        if (this.connectionState != null) {
            throw new IllegalStateException("Assignment is already started");
        }
        if (this.aborted || this.finished) {
            throw new IllegalStateException("Assignment is already done");
        }
        this.connectionState = connectionState;
        connectionState.setCurrentAssignment(this);
        this.started = System.currentTimeMillis();
    }

    void check() {
        this.checked = System.currentTimeMillis();
    }

    void finish() {
        boolean bl = this.finished = !this.aborted;
        if (this.finished && this.connectionState != null) {
            this.connectionState.removeAssignment();
        }
    }

    void abort() {
        boolean bl = this.aborted = !this.finished;
        if (this.aborted && this.connectionState != null) {
            this.connectionState.removeAssignment();
        }
    }

    public String toString() {
        return "Assignment{piece=" + this.piece + ", peer=" + this.peer + ", started=" + this.started + ", limit=" + this.limit + ", checked=" + this.checked + ", aborted=" + this.aborted + ", finished=" + this.finished + '}';
    }

    static enum Status {
        ACTIVE,
        DONE,
        TIMEOUT;

    }
}

