/*
 * Decompiled with CFR 0.152.
 */
package bt.torrent.messaging;

import bt.data.Bitfield;
import bt.net.Peer;
import bt.runtime.Config;
import bt.torrent.BitfieldBasedStatistics;
import bt.torrent.messaging.Assignment;
import bt.torrent.selector.PieceSelector;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Assignments {
    private static final Logger LOGGER = LoggerFactory.getLogger(Assignments.class);
    private static final int MAX_ASSIGNED_PIECES_PER_PEER = 50;
    private Config config;
    private Bitfield bitfield;
    private PieceSelector selector;
    private BitfieldBasedStatistics pieceStatistics;
    private Set<Integer> assignedPieces;
    private Map<Peer, Assignment> assignments;
    private Map<Peer, LinkedList<Integer>> peers;
    private Random random;

    public Assignments(Bitfield bitfield, PieceSelector selector, BitfieldBasedStatistics pieceStatistics, Config config) {
        this.bitfield = bitfield;
        this.selector = selector;
        this.pieceStatistics = pieceStatistics;
        this.config = config;
        this.assignedPieces = new HashSet<Integer>();
        this.assignments = new HashMap<Peer, Assignment>();
        this.peers = new HashMap<Peer, LinkedList<Integer>>();
        this.random = new Random(System.currentTimeMillis());
    }

    public Assignment get(Peer peer) {
        return this.assignments.get(peer);
    }

    public void remove(Assignment assignment) {
        assignment.abort();
        this.assignments.remove(assignment.getPeer());
        this.assignedPieces.remove(assignment.getPiece());
    }

    public int count() {
        return this.assignments.size();
    }

    public int workersCount() {
        return this.peers.size();
    }

    public Optional<Assignment> assign(Peer peer) {
        Optional<Integer> selectedPiece;
        StringBuilder buf;
        LinkedList<Integer> pieces = this.peers.get(peer);
        if (pieces == null || pieces.isEmpty()) {
            return Optional.empty();
        }
        boolean endgame = this.isEndgame();
        StringBuilder stringBuilder = buf = LOGGER.isTraceEnabled() ? new StringBuilder() : null;
        if (LOGGER.isTraceEnabled()) {
            buf.append("Trying to claim next assignment for peer ");
            buf.append(peer);
            buf.append(". Number of remaining pieces: ");
            buf.append(this.bitfield.getPiecesRemaining());
            buf.append(", number of pieces in progress: ");
            buf.append(this.assignedPieces.size());
            buf.append(", endgame: " + endgame);
            buf.append(". ");
        }
        if (endgame) {
            Integer pieceIndex = pieces.remove(this.random.nextInt(pieces.size()));
            selectedPiece = Optional.of(pieceIndex);
        } else {
            Integer piece;
            boolean assigned = true;
            Iterator iter = pieces.iterator();
            do {
                if (this.bitfield.isComplete(piece = (Integer)iter.next())) {
                    iter.remove();
                    if (!LOGGER.isTraceEnabled()) continue;
                    buf.append("Checking next piece in queue: {" + piece + "}; piece is completed. ");
                    continue;
                }
                assigned = this.assignedPieces.contains(piece);
                if (!assigned || !LOGGER.isTraceEnabled()) continue;
                buf.append("Checking next piece in queue: {" + piece + "}; piece is assigned. ");
            } while (assigned && iter.hasNext());
            if (!assigned) {
                iter.remove();
            }
            Optional<Object> optional = selectedPiece = assigned ? Optional.empty() : Optional.of(piece);
        }
        if (LOGGER.isTraceEnabled()) {
            if (selectedPiece.isPresent()) {
                buf.append(" => Assigning piece #");
                buf.append(selectedPiece.get());
                buf.append(" to current peer");
            } else {
                buf.append(" => No pieces to assign.");
            }
            LOGGER.trace(buf.toString());
        }
        return selectedPiece.isPresent() ? Optional.of(this.assign(peer, selectedPiece.get())) : Optional.empty();
    }

    private boolean isEndgame() {
        return this.bitfield.getPiecesRemaining() <= this.assignedPieces.size();
    }

    private Assignment assign(Peer peer, Integer piece) {
        Assignment assignment = new Assignment(peer, piece, this.config.getMaxPieceReceivingTime());
        this.assignments.put(peer, assignment);
        this.assignedPieces.add(piece);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Assigning piece #{} to peer: {}", (Object)piece, (Object)peer);
        }
        return assignment;
    }

    public Set<Peer> update(Set<Peer> ready, Set<Peer> choking) {
        Peer peer;
        Iterator suggested = this.selector.getNextPieces(this.pieceStatistics).iterator();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Updating assignments. Piece selector has more pieces: {}, number of ready peers: {}, number of assigned peers: {}", new Object[]{suggested.hasNext(), ready.size(), this.assignments.size()});
        }
        while (suggested.hasNext() && ready.size() > 0) {
            Integer piece = (Integer)suggested.next();
            Iterator<Peer> iter = new HashSet<Peer>(ready).iterator();
            while (iter.hasNext()) {
                peer = iter.next();
                Optional<Bitfield> peerBitfield = this.pieceStatistics.getPeerBitfield(peer);
                if (!peerBitfield.isPresent()) {
                    iter.remove();
                    continue;
                }
                LinkedList<Integer> queue = this.peers.get(peer);
                if (queue != null && queue.size() > 50) {
                    iter.remove();
                    continue;
                }
                boolean hasPiece = peerBitfield.get().isVerified(piece);
                if (!hasPiece) continue;
                if (queue == null) {
                    queue = new LinkedList();
                    this.peers.put(peer, queue);
                }
                if (queue.contains(piece)) continue;
                queue.add(piece);
                if (!LOGGER.isTraceEnabled()) continue;
                LOGGER.trace("Adding piece #{} to peer's queue: {}. Number of pieces in peer's queue: {}", new Object[]{piece, peer, queue.size()});
            }
        }
        Iterator<Map.Entry<Peer, LinkedList<Integer>>> iter = this.peers.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Peer, LinkedList<Integer>> e = iter.next();
            peer = e.getKey();
            LinkedList<Integer> pieces = e.getValue();
            if (ready.contains(peer) && !pieces.isEmpty()) continue;
            iter.remove();
        }
        HashSet<Peer> result = new HashSet<Peer>(this.peers.keySet());
        for (Peer peer2 : choking) {
            if (!this.hasInterestingPieces(peer2)) continue;
            result.add(peer2);
        }
        return result;
    }

    private boolean hasInterestingPieces(Peer peer) {
        Optional<Bitfield> peerBitfieldOptional = this.pieceStatistics.getPeerBitfield(peer);
        if (!peerBitfieldOptional.isPresent()) {
            return false;
        }
        BitSet peerBitfield = BitSet.valueOf(peerBitfieldOptional.get().getBitmask());
        BitSet localBitfield = BitSet.valueOf(this.bitfield.getBitmask());
        peerBitfield.andNot(localBitfield);
        return peerBitfield.cardinality() > 0;
    }
}

