/*
 * Decompiled with CFR 0.152.
 */
package bt.torrent.messaging;

import bt.net.Peer;
import bt.protocol.Bitfield;
import bt.protocol.Have;
import bt.torrent.annotation.Consumes;
import bt.torrent.messaging.MessageContext;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class BitfieldCollectingConsumer {
    private ConcurrentMap<Peer, byte[]> bitfields = new ConcurrentHashMap<Peer, byte[]>();
    private ConcurrentMap<Peer, Set<Integer>> haves = new ConcurrentHashMap<Peer, Set<Integer>>();

    @Consumes
    public void consume(Bitfield bitfieldMessage, MessageContext context) {
        this.bitfields.put(context.getPeer(), bitfieldMessage.getBitfield());
    }

    @Consumes
    public void consume(Have have, MessageContext context) {
        Peer peer = context.getPeer();
        ConcurrentHashMap.KeySetView peerHaves = (ConcurrentHashMap.KeySetView)this.haves.get(peer);
        if (peerHaves == null) {
            peerHaves = ConcurrentHashMap.newKeySet();
            this.haves.put(peer, peerHaves);
        }
        peerHaves.add(have.getPieceIndex());
    }

    public Map<Peer, byte[]> getBitfields() {
        return this.bitfields;
    }

    public Map<Peer, Set<Integer>> getHaves() {
        return this.haves;
    }
}

