/*
 * Decompiled with CFR 0.152.
 */
package bt.torrent.messaging;

import bt.event.EventSink;
import bt.net.Peer;
import bt.protocol.Bitfield;
import bt.protocol.Have;
import bt.torrent.BitfieldBasedStatistics;
import bt.torrent.annotation.Consumes;
import bt.torrent.messaging.MessageContext;

public class BitfieldConsumer {
    private bt.data.Bitfield bitfield;
    private BitfieldBasedStatistics pieceStatistics;
    private EventSink eventSink;

    public BitfieldConsumer(bt.data.Bitfield bitfield, BitfieldBasedStatistics pieceStatistics, EventSink eventSink) {
        this.bitfield = bitfield;
        this.pieceStatistics = pieceStatistics;
        this.eventSink = eventSink;
    }

    @Consumes
    public void consume(Bitfield bitfieldMessage, MessageContext context) {
        Peer peer = context.getPeer();
        bt.data.Bitfield peerBitfield = new bt.data.Bitfield(bitfieldMessage.getBitfield(), this.bitfield.getPiecesTotal());
        this.pieceStatistics.addBitfield(peer, peerBitfield);
        this.eventSink.firePeerBitfieldUpdated(context.getTorrentId().get(), peer, peerBitfield);
    }

    @Consumes
    public void consume(Have have, MessageContext context) {
        Peer peer = context.getPeer();
        this.pieceStatistics.addPiece(peer, have.getPieceIndex());
        this.pieceStatistics.getPeerBitfield(peer).ifPresent(bitfield -> this.eventSink.firePeerBitfieldUpdated(context.getTorrentId().get(), peer, (bt.data.Bitfield)bitfield));
    }
}

