/*
 * Decompiled with CFR 0.152.
 */
package bt.torrent.messaging;

import bt.protocol.Choke;
import bt.protocol.Message;
import bt.protocol.Unchoke;
import bt.torrent.messaging.ConnectionState;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Consumer;

class Choker {
    private static final Duration CHOKING_THRESHOLD = Duration.ofMillis(10000L);
    private static final Choker instance = new Choker();

    Choker() {
    }

    public static Choker choker() {
        return instance;
    }

    public void handleConnection(ConnectionState connectionState, Consumer<Message> messageConsumer) {
        Optional<Boolean> shouldChokeOptional = connectionState.getShouldChoke();
        boolean choking = connectionState.isChoking();
        boolean peerInterested = connectionState.isPeerInterested();
        if (!shouldChokeOptional.isPresent()) {
            if (peerInterested && choking) {
                if (this.mightUnchoke(connectionState)) {
                    shouldChokeOptional = Optional.of(Boolean.FALSE);
                }
            } else if (!peerInterested && !choking) {
                shouldChokeOptional = Optional.of(Boolean.TRUE);
            }
        }
        shouldChokeOptional.ifPresent(shouldChoke -> {
            if (shouldChoke != choking) {
                if (shouldChoke.booleanValue()) {
                    connectionState.setChoking(true);
                    messageConsumer.accept(Choke.instance());
                    connectionState.setLastChoked(System.currentTimeMillis());
                } else if (this.mightUnchoke(connectionState)) {
                    connectionState.setChoking(false);
                    messageConsumer.accept(Unchoke.instance());
                }
            }
        });
    }

    private boolean mightUnchoke(ConnectionState connectionState) {
        return System.currentTimeMillis() - connectionState.getLastChoked() >= CHOKING_THRESHOLD.toMillis();
    }
}

