/*
 * Decompiled with CFR 0.152.
 */
package bt.torrent.messaging;

import bt.protocol.Cancel;
import bt.protocol.Request;
import bt.torrent.data.BlockWrite;
import bt.torrent.messaging.Assignment;
import bt.torrent.messaging.Mapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;

public class ConnectionState {
    private volatile boolean interested;
    private volatile boolean peerInterested;
    private volatile boolean choking = true;
    private volatile boolean peerChoking = true;
    private volatile long downloaded;
    private volatile long uploaded;
    private Optional<Boolean> shouldChoke = Optional.empty();
    private long lastChoked;
    private Set<Object> cancelledPeerRequests = new HashSet<Object>();
    private Set<Object> pendingRequests = new HashSet<Object>();
    private Map<Object, CompletableFuture<BlockWrite>> pendingWrites = new HashMap<Object, CompletableFuture<BlockWrite>>();
    private Queue<Request> requestQueue = new LinkedBlockingQueue<Request>();
    private boolean initializedRequestQueue;
    private Optional<Assignment> assignment = Optional.empty();

    ConnectionState() {
    }

    public boolean isInterested() {
        return this.interested;
    }

    public void setInterested(boolean interested) {
        this.interested = interested;
    }

    public boolean isPeerInterested() {
        return this.peerInterested;
    }

    public void setPeerInterested(boolean peerInterested) {
        this.peerInterested = peerInterested;
    }

    public boolean isChoking() {
        return this.choking;
    }

    void setChoking(boolean choking) {
        this.choking = choking;
        this.shouldChoke = Optional.empty();
    }

    public Optional<Boolean> getShouldChoke() {
        return this.shouldChoke;
    }

    public void setShouldChoke(boolean shouldChoke) {
        this.shouldChoke = Optional.of(shouldChoke);
    }

    public long getLastChoked() {
        return this.lastChoked;
    }

    void setLastChoked(long lastChoked) {
        this.lastChoked = lastChoked;
    }

    public boolean isPeerChoking() {
        return this.peerChoking;
    }

    public void setPeerChoking(boolean peerChoking) {
        this.peerChoking = peerChoking;
    }

    public long getDownloaded() {
        return this.downloaded;
    }

    public void incrementDownloaded(long downloaded) {
        this.downloaded += downloaded;
    }

    public long getUploaded() {
        return this.uploaded;
    }

    public void incrementUploaded(long uploaded) {
        this.uploaded += uploaded;
    }

    public Set<Object> getCancelledPeerRequests() {
        return this.cancelledPeerRequests;
    }

    public void onCancel(Cancel cancel) {
        this.cancelledPeerRequests.add(Mapper.mapper().buildKey(cancel.getPieceIndex(), cancel.getOffset(), cancel.getLength()));
    }

    public Set<Object> getPendingRequests() {
        return this.pendingRequests;
    }

    public Map<Object, CompletableFuture<BlockWrite>> getPendingWrites() {
        return this.pendingWrites;
    }

    Queue<Request> getRequestQueue() {
        return this.requestQueue;
    }

    boolean initializedRequestQueue() {
        return this.initializedRequestQueue;
    }

    void setInitializedRequestQueue(boolean initializedRequestQueue) {
        this.initializedRequestQueue = initializedRequestQueue;
    }

    Optional<Assignment> getCurrentAssignment() {
        return this.assignment;
    }

    void setCurrentAssignment(Assignment assignment) {
        this.assignment = Optional.of(assignment);
    }

    void removeAssignment() {
        this.assignment = Optional.empty();
    }
}

