/*
 * Decompiled with CFR 0.152.
 */
package bt.torrent.messaging;

import bt.protocol.Message;
import bt.torrent.compiler.CompilerVisitor;
import bt.torrent.compiler.MessagingAgentCompiler;
import bt.torrent.messaging.MessageConsumer;
import bt.torrent.messaging.MessageContext;
import bt.torrent.messaging.MessageProducer;
import bt.torrent.messaging.MessageRouter;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class DefaultMessageRouter
implements MessageRouter {
    private MessagingAgentCompiler compiler = new MessagingAgentCompiler();
    private List<MessageConsumer<Message>> genericConsumers = new ArrayList<MessageConsumer<Message>>();
    private Map<Class<?>, Collection<MessageConsumer<?>>> typedConsumers = new HashMap();
    private List<MessageProducer> producers = new ArrayList<MessageProducer>();
    private List<Runnable> changes = new ArrayList<Runnable>();
    private final Object changesLock = new Object();

    public DefaultMessageRouter() {
        this(Collections.emptyList());
    }

    public DefaultMessageRouter(Collection<Object> messagingAgents) {
        messagingAgents.forEach(this::registerMessagingAgent);
    }

    @Override
    public final void registerMessagingAgent(Object agent) {
        CollectingCompilerVisitor visitor = new CollectingCompilerVisitor(agent);
        this.compiler.compileAndVisit(agent, visitor);
        this.addConsumers(visitor.getConsumers());
        this.addProducers(visitor.getProducers());
    }

    @Override
    public void unregisterMessagingAgent(Object agent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConsumers(List<MessageConsumer<?>> messageConsumers) {
        ArrayList genericConsumers = new ArrayList();
        HashMap typedMessageConsumers = new HashMap();
        messageConsumers.forEach(consumer -> {
            Class consumedType = consumer.getConsumedType();
            if (Message.class.equals(consumedType)) {
                genericConsumers.add(consumer);
            } else {
                ArrayList<MessageConsumer> consumers = (ArrayList<MessageConsumer>)typedMessageConsumers.get(consumedType);
                if (consumers == null) {
                    consumers = new ArrayList<MessageConsumer>();
                    typedMessageConsumers.put(consumedType, consumers);
                }
                consumers.add((MessageConsumer)consumer);
            }
        });
        Object object = this.changesLock;
        synchronized (object) {
            this.changes.add(() -> {
                this.genericConsumers.addAll(genericConsumers);
                this.typedConsumers.putAll(typedMessageConsumers);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProducers(Collection<MessageProducer> producers) {
        Object object = this.changesLock;
        synchronized (object) {
            this.changes.add(() -> this.producers.addAll(producers));
        }
    }

    @Override
    public void consume(Message message, MessageContext context) {
        this.mergeChanges();
        this.doConsume(message, context);
    }

    private <T extends Message> void doConsume(T message, MessageContext context) {
        this.genericConsumers.forEach(consumer -> consumer.consume(message, context));
        Collection<MessageConsumer<?>> consumers = this.typedConsumers.get(message.getClass());
        if (consumers != null) {
            consumers.forEach(consumer -> {
                MessageConsumer typedConsumer = consumer;
                typedConsumer.consume(message, context);
            });
        }
    }

    @Override
    public void produce(Consumer<Message> messageConsumer, MessageContext context) {
        this.mergeChanges();
        this.producers.forEach(producer -> producer.produce(messageConsumer, context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeChanges() {
        Object object = this.changesLock;
        synchronized (object) {
            if (!this.changes.isEmpty()) {
                this.changes.forEach(Runnable::run);
                this.changes.clear();
            }
        }
    }

    private static class CollectingCompilerVisitor
    implements CompilerVisitor {
        private Object agent;
        private final List<MessageConsumer<?>> consumers;
        private final List<MessageProducer> producers;

        public CollectingCompilerVisitor(Object agent) {
            this.agent = agent;
            this.consumers = new ArrayList();
            this.producers = new ArrayList<MessageProducer>();
        }

        @Override
        public <T extends Message> void visitConsumer(final Class<T> consumedType, final MethodHandle handle) {
            final boolean reduced = handle.type().parameterCount() == 2;
            this.consumers.add(new MessageConsumer<T>(){

                @Override
                public Class<T> getConsumedType() {
                    return consumedType;
                }

                @Override
                public void consume(T message, MessageContext context) {
                    try {
                        if (reduced) {
                            handle.invoke(agent, (Message)message);
                        } else {
                            handle.invoke(agent, (Message)message, context);
                        }
                    }
                    catch (Throwable t) {
                        throw new RuntimeException("Failed to invoke message consumer", t);
                    }
                }
            });
        }

        @Override
        public void visitProducer(MethodHandle handle) {
            boolean reduced = handle.type().parameterCount() == 2;
            this.producers.add((messageConsumer, context) -> {
                try {
                    if (reduced) {
                        handle.invoke(this.agent, messageConsumer);
                    } else {
                        handle.invoke(this.agent, messageConsumer, context);
                    }
                }
                catch (Throwable t) {
                    throw new RuntimeException("Failed to invoke message producer", t);
                }
            });
        }

        public List<MessageProducer> getProducers() {
            return this.producers;
        }

        public List<MessageConsumer<?>> getConsumers() {
            return this.consumers;
        }
    }
}

