/*
 * Decompiled with CFR 0.152.
 */
package bt.torrent.messaging;

import bt.data.BlockSet;
import bt.data.digest.SHA1Digester;
import bt.data.range.BlockRange;
import bt.data.range.ByteRange;
import bt.data.range.Range;
import bt.data.range.Ranges;

class ExchangedMetadata {
    private volatile Range<BlockRange<ByteRange>> metadata;
    private volatile BlockSet metadataBlocks;
    private volatile byte[] digest;
    private final Object digestLock;

    ExchangedMetadata(byte[] data, int blockSize) {
        BlockRange<ByteRange> range = Ranges.blockRange(new ByteRange(data), blockSize);
        this.metadata = Ranges.synchronizedRange(range);
        this.metadataBlocks = Ranges.synchronizedBlockSet(range.getBlockSet());
        this.digestLock = new Object();
    }

    ExchangedMetadata(int totalSize, int blockSize) {
        this(new byte[totalSize], blockSize);
    }

    public boolean isBlockPresent(int blockIndex) {
        return this.metadataBlocks.isPresent(blockIndex);
    }

    public void setBlock(int blockIndex, byte[] block) {
        this.validateBlockIndex(blockIndex);
        this.metadata.getSubrange((long)blockIndex * this.metadataBlocks.blockSize()).putBytes(block);
    }

    public int getBlockCount() {
        return this.metadataBlocks.blockCount();
    }

    public boolean isComplete() {
        return this.metadataBlocks.isComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSha1Digest() {
        if (!this.metadataBlocks.isComplete()) {
            throw new IllegalStateException("Metadata is not complete");
        }
        if (this.digest == null) {
            Object object = this.digestLock;
            synchronized (object) {
                if (this.digest == null) {
                    this.digest = SHA1Digester.rolling(1000000).digest(this.metadata);
                }
            }
        }
        return this.digest;
    }

    public byte[] getBytes() {
        if (!this.metadataBlocks.isComplete()) {
            throw new IllegalStateException("Metadata is not complete");
        }
        return this.metadata.getBytes();
    }

    public byte[] getBlock(int blockIndex) {
        this.validateBlockIndex(blockIndex);
        int blockLength = blockIndex == this.metadataBlocks.blockCount() - 1 ? (int)this.metadataBlocks.lastBlockSize() : (int)this.metadataBlocks.blockSize();
        return this.metadata.getSubrange((long)blockIndex * this.metadataBlocks.blockSize(), blockLength).getBytes();
    }

    public int length() {
        return (int)this.metadata.length();
    }

    private void validateBlockIndex(int blockIndex) {
        int blockCount = this.metadataBlocks.blockCount();
        if (blockIndex < 0 || blockIndex >= blockCount) {
            throw new IllegalArgumentException("Invalid block index: " + blockIndex + "; expected 0.." + blockCount);
        }
    }
}

