/*
 * Decompiled with CFR 0.152.
 */
package bt.torrent.messaging;

import bt.magnet.UtMetadata;
import bt.metainfo.IMetadataService;
import bt.metainfo.Torrent;
import bt.metainfo.TorrentId;
import bt.net.Peer;
import bt.protocol.Message;
import bt.protocol.extended.ExtendedHandshake;
import bt.runtime.Config;
import bt.torrent.annotation.Consumes;
import bt.torrent.annotation.Produces;
import bt.torrent.messaging.ExchangedMetadata;
import bt.torrent.messaging.MessageContext;
import java.time.Duration;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataConsumer.class);
    private static final Duration FIRST_BLOCK_ARRIVAL_TIMEOUT = Duration.ofSeconds(10L);
    private static final Duration WAIT_BEFORE_REREQUESTING_AFTER_REJECT = Duration.ofSeconds(10L);
    private final ConcurrentMap<Peer, Long> peersWithoutMetadata = new ConcurrentHashMap<Peer, Long>();
    private final Set<Peer> supportingPeers = ConcurrentHashMap.newKeySet();
    private final ConcurrentMap<Peer, Long> requestedFirstPeers = new ConcurrentHashMap<Peer, Long>();
    private final Set<Peer> requestedAllPeers = ConcurrentHashMap.newKeySet();
    private volatile ExchangedMetadata metadata;
    private final IMetadataService metadataService;
    private final TorrentId torrentId;
    private final AtomicReference<Torrent> torrent;
    private final int metadataExchangeBlockSize;
    private final int metadataExchangeMaxSize;

    public MetadataConsumer(IMetadataService metadataService, TorrentId torrentId, Config config) {
        this.metadataService = metadataService;
        this.torrentId = Objects.requireNonNull(torrentId);
        this.torrent = new AtomicReference();
        this.metadataExchangeBlockSize = config.getMetadataExchangeBlockSize();
        this.metadataExchangeMaxSize = config.getMetadataExchangeMaxSize();
    }

    @Consumes
    public void consume(ExtendedHandshake handshake, MessageContext messageContext) {
        if (handshake.getSupportedMessageTypes().contains("ut_metadata")) {
            this.supportingPeers.add(messageContext.getPeer());
        }
    }

    @Consumes
    public void consume(UtMetadata message, MessageContext context) {
        Peer peer = context.getPeer();
        switch (message.getType()) {
            case DATA: {
                int totalSize = message.getTotalSize().get();
                if (totalSize >= this.metadataExchangeMaxSize) {
                    throw new IllegalStateException("Declared metadata size is too large: " + totalSize + "; max allowed is " + this.metadataExchangeMaxSize);
                }
                this.processMetadataBlock(message.getPieceIndex(), totalSize, message.getData().get());
            }
            case REJECT: {
                this.peersWithoutMetadata.put(peer, System.currentTimeMillis());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMetadataBlock(int pieceIndex, int totalSize, byte[] data) {
        if (this.metadata == null) {
            this.metadata = new ExchangedMetadata(totalSize, this.metadataExchangeBlockSize);
        }
        if (!this.metadata.isBlockPresent(pieceIndex)) {
            this.metadata.setBlock(pieceIndex, data);
            if (this.metadata.isComplete()) {
                byte[] digest = this.metadata.getSha1Digest();
                if (Arrays.equals(digest, this.torrentId.getBytes())) {
                    Torrent fetchedTorrent = null;
                    try {
                        fetchedTorrent = this.metadataService.fromByteArray(this.metadata.getBytes());
                    }
                    catch (Exception e) {
                        LOGGER.error("Processing of metadata failed: " + this.torrentId, (Throwable)e);
                        this.metadata = null;
                    }
                    if (fetchedTorrent != null) {
                        AtomicReference<Torrent> atomicReference = this.torrent;
                        synchronized (atomicReference) {
                            this.torrent.set(fetchedTorrent);
                            this.requestedFirstPeers.clear();
                            this.requestedAllPeers.clear();
                            this.torrent.notifyAll();
                        }
                    }
                } else {
                    LOGGER.warn("Metadata fetched, but hash does not match the torrent ID: {}. Will re-fetch", (Object)this.torrentId);
                    this.metadata = null;
                }
            }
        }
    }

    @Produces
    public void produce(Consumer<Message> messageConsumer, MessageContext context) {
        if (this.torrent.get() != null) {
            return;
        }
        Peer peer = context.getPeer();
        if (this.supportingPeers.contains(peer)) {
            if (this.peersWithoutMetadata.containsKey(peer) && System.currentTimeMillis() - (Long)this.peersWithoutMetadata.get(peer) >= WAIT_BEFORE_REREQUESTING_AFTER_REJECT.toMillis()) {
                this.peersWithoutMetadata.remove(peer);
            }
            if (!this.peersWithoutMetadata.containsKey(peer)) {
                if (this.metadata == null) {
                    if (!this.requestedFirstPeers.containsKey(peer) || System.currentTimeMillis() - (Long)this.requestedFirstPeers.get(peer) > FIRST_BLOCK_ARRIVAL_TIMEOUT.toMillis()) {
                        this.requestedFirstPeers.put(peer, System.currentTimeMillis());
                        messageConsumer.accept(UtMetadata.request(0));
                    }
                } else if (!this.requestedAllPeers.contains(peer)) {
                    this.requestedAllPeers.add(peer);
                    for (int i = 1; i < this.metadata.getBlockCount(); ++i) {
                        messageConsumer.accept(UtMetadata.request(i));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Torrent waitForTorrent() {
        if (this.torrent.get() == null) {
            AtomicReference<Torrent> atomicReference = this.torrent;
            synchronized (atomicReference) {
                if (this.torrent.get() == null) {
                    try {
                        this.torrent.wait();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.torrent.get();
    }
}

