/*
 * Decompiled with CFR 0.152.
 */
package bt.torrent.messaging;

import bt.magnet.UtMetadata;
import bt.metainfo.Torrent;
import bt.net.Peer;
import bt.protocol.Message;
import bt.runtime.Config;
import bt.torrent.annotation.Consumes;
import bt.torrent.annotation.Produces;
import bt.torrent.messaging.ExchangedMetadata;
import bt.torrent.messaging.MessageContext;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class MetadataProducer {
    private final Supplier<Torrent> torrentSupplier;
    private volatile ExchangedMetadata metadata;
    private final ConcurrentMap<Peer, Queue<Message>> outboundMessages;
    private final int metadataExchangeBlockSize;

    public MetadataProducer(Supplier<Torrent> torrentSupplier, Config config) {
        this.torrentSupplier = torrentSupplier;
        this.outboundMessages = new ConcurrentHashMap<Peer, Queue<Message>>();
        this.metadataExchangeBlockSize = config.getMetadataExchangeBlockSize();
    }

    @Consumes
    public void consume(UtMetadata message, MessageContext context) {
        Peer peer = context.getPeer();
        switch (message.getType()) {
            case REQUEST: {
                this.processMetadataRequest(peer, message.getPieceIndex());
            }
        }
    }

    private void processMetadataRequest(Peer peer, int pieceIndex) {
        UtMetadata response;
        Torrent torrent = this.torrentSupplier.get();
        if (torrent == null || torrent.isPrivate()) {
            response = UtMetadata.reject(pieceIndex);
        } else {
            if (this.metadata == null) {
                this.metadata = new ExchangedMetadata(torrent.getSource().getExchangedMetadata(), this.metadataExchangeBlockSize);
            }
            response = UtMetadata.data(pieceIndex, this.metadata.length(), this.metadata.getBlock(pieceIndex));
        }
        this.getOrCreateOutboundMessages(peer).add(response);
    }

    private Queue<Message> getOrCreateOutboundMessages(Peer peer) {
        Queue existing;
        Queue queue = (LinkedBlockingQueue)this.outboundMessages.get(peer);
        if (queue == null && (existing = (Queue)this.outboundMessages.putIfAbsent(peer, queue = new LinkedBlockingQueue())) != null) {
            queue = existing;
        }
        return queue;
    }

    @Produces
    public void produce(Consumer<Message> messageConsumer, MessageContext context) {
        Peer peer = context.getPeer();
        Queue queue = (Queue)this.outboundMessages.get(peer);
        if (queue != null && queue.size() > 0) {
            messageConsumer.accept((Message)queue.poll());
        }
    }
}

