/*
 * Decompiled with CFR 0.152.
 */
package bt.torrent.messaging;

import bt.BtException;
import bt.net.Peer;
import bt.protocol.InvalidMessageException;
import bt.protocol.Message;
import bt.protocol.Piece;
import bt.protocol.Request;
import bt.torrent.annotation.Consumes;
import bt.torrent.annotation.Produces;
import bt.torrent.data.BlockRead;
import bt.torrent.data.DataWorker;
import bt.torrent.messaging.ConnectionState;
import bt.torrent.messaging.MessageContext;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerRequestConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeerRequestConsumer.class);
    private DataWorker dataWorker;
    private Map<Peer, Queue<BlockRead>> completedRequests;

    public PeerRequestConsumer(DataWorker dataWorker) {
        this.dataWorker = dataWorker;
        this.completedRequests = new ConcurrentHashMap<Peer, Queue<BlockRead>>();
    }

    @Consumes
    public void consume(Request request, MessageContext context) {
        ConnectionState connectionState = context.getConnectionState();
        if (!connectionState.isChoking()) {
            this.addBlockRequest(context.getPeer(), request).whenComplete((block, error) -> {
                if (error != null) {
                    throw new RuntimeException("Failed to perform request to read block", (Throwable)error);
                }
                if (block.getError().isPresent()) {
                    throw new RuntimeException("Failed to perform request to read block", block.getError().get());
                }
                if (block.isRejected()) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("Request to read block could not be completed: " + request);
                    }
                    connectionState.setShouldChoke(true);
                } else {
                    this.getCompletedRequestsForPeer(context.getPeer()).add((BlockRead)block);
                }
            });
        }
    }

    private CompletableFuture<BlockRead> addBlockRequest(Peer peer, Request request) {
        return this.dataWorker.addBlockRequest(peer, request.getPieceIndex(), request.getOffset(), request.getLength());
    }

    private Queue<BlockRead> getCompletedRequestsForPeer(Peer peer) {
        Queue<BlockRead> existing;
        Queue<BlockRead> queue = this.completedRequests.get(peer);
        if (queue == null && (existing = this.completedRequests.putIfAbsent(peer, queue = new ConcurrentLinkedQueue<BlockRead>())) != null) {
            queue = existing;
        }
        return queue;
    }

    @Produces
    public void produce(Consumer<Message> messageConsumer, MessageContext context) {
        BlockRead block;
        Peer peer = context.getPeer();
        Queue<BlockRead> queue = this.getCompletedRequestsForPeer(peer);
        while ((block = queue.poll()) != null) {
            try {
                messageConsumer.accept(new Piece(block.getPieceIndex(), block.getOffset(), block.getBlock().get()));
            }
            catch (InvalidMessageException e) {
                throw new BtException("Failed to send PIECE", e);
            }
        }
    }
}

