/*
 * Decompiled with CFR 0.152.
 */
package bt.torrent.messaging;

import bt.metainfo.TorrentId;
import bt.net.Peer;
import bt.torrent.messaging.IPeerWorkerFactory;
import bt.torrent.messaging.MessageRouter;
import bt.torrent.messaging.PeerWorker;
import bt.torrent.messaging.RoutingPeerWorker;
import java.util.Optional;

public class PeerWorkerFactory
implements IPeerWorkerFactory {
    private MessageRouter router;

    public PeerWorkerFactory(MessageRouter router) {
        this.router = router;
    }

    @Override
    public PeerWorker createPeerWorker(Peer peer) {
        return this.createPeerWorker(Optional.empty(), peer);
    }

    @Override
    public PeerWorker createPeerWorker(TorrentId torrentId, Peer peer) {
        return this.createPeerWorker(Optional.of(torrentId), peer);
    }

    private PeerWorker createPeerWorker(Optional<TorrentId> torrentId, Peer peer) {
        return new RoutingPeerWorker(peer, torrentId, this.router);
    }
}

