/*
 * Decompiled with CFR 0.152.
 */
package bt.torrent.messaging;

import bt.BtException;
import bt.data.Bitfield;
import bt.data.ChunkDescriptor;
import bt.data.DataDescriptor;
import bt.net.Peer;
import bt.protocol.Cancel;
import bt.protocol.InvalidMessageException;
import bt.protocol.Message;
import bt.protocol.Request;
import bt.torrent.annotation.Produces;
import bt.torrent.data.BlockWrite;
import bt.torrent.messaging.Assignment;
import bt.torrent.messaging.ConnectionState;
import bt.torrent.messaging.Mapper;
import bt.torrent.messaging.MessageContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestProducer.class);
    private static final int MAX_PENDING_REQUESTS = 5;
    private Bitfield bitfield;
    private List<ChunkDescriptor> chunks;

    public RequestProducer(DataDescriptor dataDescriptor) {
        this.bitfield = dataDescriptor.getBitfield();
        this.chunks = dataDescriptor.getChunkDescriptors();
    }

    @Produces
    public void produce(Consumer<Message> messageConsumer, MessageContext context) {
        Peer peer = context.getPeer();
        ConnectionState connectionState = context.getConnectionState();
        if (!connectionState.getCurrentAssignment().isPresent()) {
            this.resetConnection(connectionState, messageConsumer);
            return;
        }
        Assignment assignment = connectionState.getCurrentAssignment().get();
        int currentPiece = assignment.getPiece();
        if (this.bitfield.isComplete(currentPiece)) {
            assignment.finish();
            this.resetConnection(connectionState, messageConsumer);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Finished downloading piece #{}", (Object)currentPiece);
            }
            return;
        }
        if (!connectionState.initializedRequestQueue()) {
            connectionState.getPendingWrites().clear();
            this.initializeRequestQueue(connectionState, currentPiece);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Begin downloading piece #{} from peer: {}. Request queue length: {}", new Object[]{currentPiece, peer, connectionState.getRequestQueue().size()});
            }
        }
        Queue<Request> requestQueue = connectionState.getRequestQueue();
        while (!requestQueue.isEmpty() && connectionState.getPendingRequests().size() <= 5) {
            Request request = requestQueue.poll();
            Object key = Mapper.mapper().buildKey(request.getPieceIndex(), request.getOffset(), request.getLength());
            messageConsumer.accept(request);
            connectionState.getPendingRequests().add(key);
        }
    }

    private void resetConnection(ConnectionState connectionState, Consumer<Message> messageConsumer) {
        connectionState.getRequestQueue().clear();
        connectionState.setInitializedRequestQueue(false);
        connectionState.getPendingRequests().forEach(r -> Mapper.decodeKey(r).ifPresent(key -> messageConsumer.accept(new Cancel(key.getPieceIndex(), key.getOffset(), key.getLength()))));
        connectionState.getPendingRequests().clear();
    }

    private void initializeRequestQueue(ConnectionState connectionState, int pieceIndex) {
        List requests = this.buildRequests(pieceIndex).stream().filter(request -> {
            boolean failed;
            Object key = Mapper.mapper().buildKey(request.getPieceIndex(), request.getOffset(), request.getLength());
            if (connectionState.getPendingRequests().contains(key)) {
                return false;
            }
            CompletableFuture<BlockWrite> future = connectionState.getPendingWrites().get(key);
            if (future == null) {
                return true;
            }
            if (!future.isDone()) {
                return false;
            }
            boolean bl = failed = future.isDone() && ((BlockWrite)future.getNow(null)).getError().isPresent();
            if (failed) {
                connectionState.getPendingWrites().remove(key);
            }
            return failed;
        }).collect(Collectors.toList());
        Collections.shuffle(requests);
        connectionState.getRequestQueue().addAll(requests);
        connectionState.setInitializedRequestQueue(true);
    }

    private List<Request> buildRequests(int pieceIndex) {
        ArrayList<Request> requests = new ArrayList<Request>();
        ChunkDescriptor chunk = this.chunks.get(pieceIndex);
        long chunkSize = chunk.getData().length();
        long blockSize = chunk.blockSize();
        for (int blockIndex = 0; blockIndex < chunk.blockCount(); ++blockIndex) {
            if (chunk.isPresent(blockIndex)) continue;
            int offset = (int)((long)blockIndex * blockSize);
            int length = (int)Math.min(blockSize, chunkSize - (long)offset);
            try {
                requests.add(new Request(pieceIndex, offset, length));
                continue;
            }
            catch (InvalidMessageException e) {
                throw new BtException("Unexpected error", e);
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Built {} requests for piece #{} (size: {}, block size: {}, number of blocks: {})", new Object[]{requests.size(), pieceIndex, chunkSize, blockSize, chunk.blockCount()});
        }
        return requests;
    }
}

