/*
 * Decompiled with CFR 0.152.
 */
package bt.torrent.messaging;

import bt.metainfo.TorrentId;
import bt.net.Peer;
import bt.protocol.Cancel;
import bt.protocol.Choke;
import bt.protocol.Interested;
import bt.protocol.Message;
import bt.protocol.NotInterested;
import bt.protocol.Piece;
import bt.protocol.Unchoke;
import bt.torrent.messaging.Choker;
import bt.torrent.messaging.ConnectionState;
import bt.torrent.messaging.Mapper;
import bt.torrent.messaging.MessageContext;
import bt.torrent.messaging.MessageRouter;
import bt.torrent.messaging.PeerWorker;
import java.util.Deque;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingDeque;

class RoutingPeerWorker
implements PeerWorker {
    private ConnectionState connectionState = new ConnectionState();
    private MessageRouter router;
    private MessageContext context;
    private Deque<Message> outgoingMessages;
    private Choker choker;

    public RoutingPeerWorker(Peer peer, Optional<TorrentId> torrentId, MessageRouter router) {
        this.router = router;
        this.context = new MessageContext(torrentId, peer, this.connectionState);
        this.outgoingMessages = new LinkedBlockingDeque<Message>();
        this.choker = Choker.choker();
    }

    @Override
    public ConnectionState getConnectionState() {
        return this.connectionState;
    }

    @Override
    public void accept(Message message) {
        this.router.consume(message, this.context);
        this.updateConnection();
    }

    private void postMessage(Message message) {
        if (this.isUrgent(message)) {
            this.addUrgent(message);
        } else {
            this.add(message);
        }
    }

    private boolean isUrgent(Message message) {
        Class<?> messageType = message.getClass();
        return Choke.class.equals(messageType) || Unchoke.class.equals(messageType) || Cancel.class.equals(messageType);
    }

    private void add(Message message) {
        this.outgoingMessages.add(message);
    }

    private void addUrgent(Message message) {
        this.outgoingMessages.addFirst(message);
    }

    @Override
    public Message get() {
        if (this.outgoingMessages.isEmpty()) {
            this.router.produce(this::postMessage, this.context);
            this.updateConnection();
        }
        return this.postProcessOutgoingMessage(this.outgoingMessages.poll());
    }

    private Message postProcessOutgoingMessage(Message message) {
        if (message == null) {
            return null;
        }
        Class<?> messageType = message.getClass();
        if (Piece.class.equals(messageType)) {
            Piece piece = (Piece)message;
            if (this.isCancelled(piece)) {
                return null;
            }
            this.connectionState.incrementUploaded(piece.getBlock().length);
        }
        if (Interested.class.equals(messageType)) {
            this.connectionState.setInterested(true);
        }
        if (NotInterested.class.equals(messageType)) {
            this.connectionState.setInterested(false);
        }
        if (Choke.class.equals(messageType)) {
            this.connectionState.setShouldChoke(true);
        }
        if (Unchoke.class.equals(messageType)) {
            this.connectionState.setShouldChoke(false);
        }
        return message;
    }

    private boolean isCancelled(Piece piece) {
        int pieceIndex = piece.getPieceIndex();
        int offset = piece.getOffset();
        int length = piece.getBlock().length;
        return this.connectionState.getCancelledPeerRequests().remove(Mapper.mapper().buildKey(pieceIndex, offset, length));
    }

    private void updateConnection() {
        this.choker.handleConnection(this.connectionState, this::postMessage);
    }
}

