/*
 * Decompiled with CFR 0.152.
 */
package bt.torrent.selector;

import bt.torrent.PieceStatistics;
import bt.torrent.selector.BaseStreamSelector;
import bt.torrent.selector.PackedIntComparator;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.PriorityQueue;
import java.util.Random;

public class RarestFirstSelector
extends BaseStreamSelector {
    private static final Comparator<Long> comparator = new PackedIntComparator();
    private static final int RANDOMIZED_SELECTION_SIZE = 10;
    private Optional<Random> random;

    public static RarestFirstSelector rarest() {
        return new RarestFirstSelector(false);
    }

    public static RarestFirstSelector randomizedRarest() {
        return new RarestFirstSelector(true);
    }

    private RarestFirstSelector(boolean randomized) {
        this.random = randomized ? Optional.of(new Random(System.currentTimeMillis())) : Optional.empty();
    }

    @Override
    protected PrimitiveIterator.OfInt createIterator(PieceStatistics pieceStatistics) {
        final LinkedList<Integer> queue = this.orderedQueue(pieceStatistics);
        return new PrimitiveIterator.OfInt(){

            @Override
            public int nextInt() {
                if (RarestFirstSelector.this.random.isPresent()) {
                    int i = Math.min(10, queue.size());
                    return (Integer)queue.remove(((Random)RarestFirstSelector.this.random.get()).nextInt(i));
                }
                return (Integer)queue.poll();
            }

            @Override
            public boolean hasNext() {
                return !queue.isEmpty();
            }
        };
    }

    private LinkedList<Integer> orderedQueue(PieceStatistics pieceStatistics) {
        Long l;
        PriorityQueue<Long> rarestFirst = new PriorityQueue<Long>(comparator);
        int piecesTotal = pieceStatistics.getPiecesTotal();
        for (int pieceIndex = 0; pieceIndex < piecesTotal; ++pieceIndex) {
            int count = pieceStatistics.getCount(pieceIndex);
            if (count <= 0) continue;
            long packed = ((long)pieceIndex << 32) + (long)count;
            rarestFirst.add(packed);
        }
        LinkedList<Integer> result = new LinkedList<Integer>();
        while ((l = rarestFirst.poll()) != null) {
            result.add((int)(l >> 32));
        }
        return result;
    }
}

