/*
 * Decompiled with CFR 0.152.
 */
package bt.tracker;

import java.util.Collections;
import java.util.List;

public class AnnounceKey {
    private final String trackerUrl;
    private final List<List<String>> trackerUrls;

    public AnnounceKey(String trackerUrl) {
        this.trackerUrl = trackerUrl;
        this.trackerUrls = null;
    }

    public AnnounceKey(List<List<String>> trackerUrls) {
        this.trackerUrl = null;
        this.trackerUrls = Collections.unmodifiableList(trackerUrls);
    }

    public boolean isMultiKey() {
        return this.trackerUrls != null;
    }

    public String getTrackerUrl() {
        return this.trackerUrl;
    }

    public List<List<String>> getTrackerUrls() {
        return this.trackerUrls;
    }

    public String toString() {
        if (this.isMultiKey()) {
            return this.trackerUrls.toString();
        }
        return this.trackerUrl;
    }

    public int hashCode() {
        return this.isMultiKey() ? this.trackerUrls.hashCode() : this.trackerUrl.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnounceKey that = (AnnounceKey)o;
        return this.isMultiKey() ? this.trackerUrls.equals(that.trackerUrls) : this.trackerUrl.equals(that.trackerUrl);
    }
}

