/*
 * Decompiled with CFR 0.152.
 */
package bt.tracker;

import bt.BtException;
import bt.net.InetPeer;
import bt.net.Peer;
import bt.peer.PeerOptions;
import bt.protocol.crypto.EncryptionPolicy;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;

public class CompactPeerInfo
implements Iterable<Peer> {
    private static final int PORT_LENGTH = 2;
    private final int addressLength;
    private final byte[] peers;
    private final Optional<byte[]> cryptoFlags;
    private final List<Peer> peerList;

    public CompactPeerInfo(byte[] peers, AddressType addressType) {
        this(peers, addressType, null);
    }

    public CompactPeerInfo(byte[] peers, AddressType addressType, byte[] cryptoFlags) {
        Objects.requireNonNull(peers);
        Objects.requireNonNull(addressType);
        int peerLength = addressType.length() + 2;
        if (peers.length % peerLength != 0) {
            throw new IllegalArgumentException("Invalid peers string (" + addressType.name() + ") -- length (" + peers.length + ") is not divisible by " + peerLength);
        }
        int numOfPeers = peers.length / peerLength;
        if (cryptoFlags != null && cryptoFlags.length != numOfPeers) {
            throw new IllegalArgumentException("Number of peers (" + numOfPeers + ") is different from the number of crypto flags (" + cryptoFlags.length + ")");
        }
        this.addressLength = addressType.length();
        this.peers = peers;
        this.cryptoFlags = Optional.ofNullable(cryptoFlags);
        this.peerList = new ArrayList<Peer>();
    }

    @Override
    public Iterator<Peer> iterator() {
        if (!this.peerList.isEmpty()) {
            return this.peerList.iterator();
        }
        return new Iterator<Peer>(){
            private int pos;
            private int index;

            @Override
            public boolean hasNext() {
                return this.pos < CompactPeerInfo.this.peers.length;
            }

            @Override
            public Peer next() {
                boolean requiresEncryption;
                InetAddress inetAddress;
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more peers left");
                }
                int from = this.pos;
                int to = this.pos += CompactPeerInfo.this.addressLength;
                try {
                    inetAddress = InetAddress.getByAddress(Arrays.copyOfRange(CompactPeerInfo.this.peers, from, to));
                }
                catch (UnknownHostException e) {
                    throw new BtException("Failed to get next peer", e);
                }
                from = to;
                to = this.pos += 2;
                int port = (CompactPeerInfo.this.peers[from] << 8 & 0xFF00) + (CompactPeerInfo.this.peers[to - 1] & 0xFF);
                InetSocketAddress addr = new InetSocketAddress(inetAddress, port);
                PeerOptions options = PeerOptions.defaultOptions();
                boolean bl = requiresEncryption = CompactPeerInfo.this.cryptoFlags.isPresent() && ((byte[])CompactPeerInfo.this.cryptoFlags.get())[this.index] == 1;
                if (requiresEncryption) {
                    options = options.withEncryptionPolicy(EncryptionPolicy.PREFER_ENCRYPTED);
                }
                InetPeer peer = new InetPeer(addr, options);
                CompactPeerInfo.this.peerList.add(peer);
                ++this.index;
                return peer;
            }
        };
    }

    public static enum AddressType {
        IPV4(4),
        IPV6(16);

        private int length;

        private AddressType(int length) {
            this.length = length;
        }

        public int length() {
            return this.length;
        }
    }
}

