/*
 * Decompiled with CFR 0.152.
 */
package bt.tracker;

import bt.BtException;
import bt.metainfo.TorrentId;
import bt.tracker.AnnounceKey;
import bt.tracker.ITrackerService;
import bt.tracker.Tracker;
import bt.tracker.TrackerRequestBuilder;
import bt.tracker.TrackerResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MultiTracker
implements Tracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiTracker.class);
    private ITrackerService trackerService;
    private List<List<Tracker>> trackerTiers;

    MultiTracker(ITrackerService trackerService, AnnounceKey announceKey) {
        this(trackerService, announceKey, true);
    }

    MultiTracker(ITrackerService trackerService, AnnounceKey announceKey, boolean shouldShuffleTiers) {
        if (!announceKey.isMultiKey()) {
            throw new IllegalArgumentException("Not a multi key: " + announceKey);
        }
        this.trackerService = trackerService;
        this.trackerTiers = this.initTrackers(announceKey, shouldShuffleTiers);
    }

    private List<List<Tracker>> initTrackers(AnnounceKey announceKey, boolean shouldShuffleTiers) {
        List<List<String>> trackerUrls = announceKey.getTrackerUrls();
        ArrayList<List<Tracker>> trackers = new ArrayList<List<Tracker>>(trackerUrls.size() + 1);
        for (List<String> tier : trackerUrls) {
            ArrayList<LazyTracker> tierTrackers = new ArrayList<LazyTracker>(tier.size() + 1);
            for (String trackerUrl : tier) {
                tierTrackers.add(new LazyTracker(() -> this.trackerService.getTracker(trackerUrl)));
            }
            if (shouldShuffleTiers) {
                Collections.shuffle(tierTrackers);
            }
            trackers.add(tierTrackers);
        }
        return trackers;
    }

    @Override
    public TrackerRequestBuilder request(final TorrentId torrentId) {
        return new TrackerRequestBuilder(torrentId){

            @Override
            public TrackerResponse start() {
                return this.tryForAllTrackers(tracker -> this.getDelegate((Tracker)tracker, torrentId).start());
            }

            @Override
            public TrackerResponse stop() {
                return this.tryForAllTrackers(tracker -> this.getDelegate((Tracker)tracker, torrentId).stop());
            }

            @Override
            public TrackerResponse complete() {
                return this.tryForAllTrackers(tracker -> this.getDelegate((Tracker)tracker, torrentId).complete());
            }

            @Override
            public TrackerResponse query() {
                return this.tryForAllTrackers(tracker -> this.getDelegate((Tracker)tracker, torrentId).query());
            }

            private TrackerRequestBuilder getDelegate(Tracker tracker, TorrentId torrentId2) {
                long left;
                long uploaded;
                TrackerRequestBuilder delegate = tracker.request(torrentId2);
                long downloaded = this.getDownloaded();
                if (downloaded > 0L) {
                    delegate.downloaded(downloaded);
                }
                if ((uploaded = this.getUploaded()) > 0L) {
                    delegate.uploaded(uploaded);
                }
                if ((left = this.getLeft()) > 0L) {
                    delegate.left(left);
                }
                return delegate;
            }

            private TrackerResponse tryForAllTrackers(Function<Tracker, TrackerResponse> func) {
                ArrayList<TrackerResponse> responses = new ArrayList<TrackerResponse>();
                for (List trackerTier : MultiTracker.this.trackerTiers) {
                    for (int i = 0; i < trackerTier.size(); ++i) {
                        Tracker currentTracker = (Tracker)trackerTier.get(i);
                        TrackerResponse response = func.apply(currentTracker);
                        responses.add(response);
                        if (response.isSuccess()) {
                            if (trackerTier.size() > 1) {
                                trackerTier.remove(i);
                                trackerTier.add(0, currentTracker);
                            }
                            return response;
                        }
                        if (response.getError().isPresent()) {
                            Throwable e = response.getError().get();
                            LOGGER.warn("Unexpected error during interaction with the tracker: " + currentTracker, e);
                            continue;
                        }
                        LOGGER.warn("Unexpected error during interaction with the tracker: " + currentTracker + "; message: " + response.getErrorMessage());
                    }
                }
                throw new BtException("All trackers failed; responses (in chrono order): " + responses);
            }
        };
    }

    public String toString() {
        return "MultiTracker{trackerTiers=" + this.trackerTiers + '}';
    }

    private static class LazyTracker
    implements Tracker {
        private volatile Tracker delegate;
        private Supplier<Tracker> delegateSupplier;
        private final Object lock;

        LazyTracker(Supplier<Tracker> delegateSupplier) {
            this.delegateSupplier = delegateSupplier;
            this.lock = new Object();
        }

        @Override
        public TrackerRequestBuilder request(TorrentId torrentId) {
            return this.getDelegate().request(torrentId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Tracker getDelegate() {
            if (this.delegate == null) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.delegate == null) {
                        this.delegate = this.delegateSupplier.get();
                    }
                }
            }
            return this.delegate;
        }

        public String toString() {
            return this.getDelegate().toString();
        }
    }
}

