/*
 * Decompiled with CFR 0.152.
 */
package bt.tracker;

import bt.BtException;
import bt.metainfo.TorrentId;
import bt.tracker.TrackerResponse;
import java.util.Objects;

public abstract class TrackerRequestBuilder {
    private TorrentId torrentId;
    private long uploaded;
    private long downloaded;
    private long left;

    protected TrackerRequestBuilder(TorrentId torrentId) {
        this.torrentId = Objects.requireNonNull(torrentId);
    }

    public abstract TrackerResponse start();

    public abstract TrackerResponse stop();

    public abstract TrackerResponse complete();

    public abstract TrackerResponse query();

    public TrackerRequestBuilder uploaded(long uploaded) {
        if (uploaded < 0L) {
            throw new BtException("Invalid uploaded value: " + uploaded);
        }
        this.uploaded = uploaded;
        return this;
    }

    public TrackerRequestBuilder downloaded(long downloaded) {
        if (downloaded < 0L) {
            throw new BtException("Invalid downloaded value: " + downloaded);
        }
        this.downloaded = downloaded;
        return this;
    }

    public TrackerRequestBuilder left(long left) {
        if (left < 0L) {
            throw new BtException("Invalid left value: " + left);
        }
        this.left = left;
        return this;
    }

    public TorrentId getTorrentId() {
        return this.torrentId;
    }

    public long getUploaded() {
        return this.uploaded;
    }

    public long getDownloaded() {
        return this.downloaded;
    }

    public long getLeft() {
        return this.left;
    }
}

